/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.AbstractNumberListEntry;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public class DoubleListEntry
extends AbstractNumberListEntry<Double> {
    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(Component fieldName, Double value, Component resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveCallback = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(Component fieldName, Double value, Component resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public DoubleListEntry(Component fieldName, Double value, Component resetButtonKey, Supplier<Double> defaultValue, Consumer<Double> saveConsumer, Supplier<Optional<Component[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveCallback = saveConsumer;
    }

    @Override
    protected Map.Entry<Double, Double> getDefaultRange() {
        return new AbstractMap.SimpleEntry<Double, Double>(-1.7976931348623157E308, (Double)Double.MAX_VALUE);
    }

    public DoubleListEntry setMinimum(double minimum) {
        this.minimum = minimum;
        return this;
    }

    public DoubleListEntry setMaximum(double maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Double getValue() {
        try {
            return Double.valueOf(this.textFieldWidget.getValue());
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public Optional<Component> getError() {
        try {
            double i = Double.parseDouble(this.textFieldWidget.getValue());
            if (i > (Double)this.maximum) {
                return Optional.of(Component.translatable((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < (Double)this.minimum) {
                return Optional.of(Component.translatable((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(Component.translatable((String)"text.cloth-config.error.not_valid_number_double"));
        }
        return super.getError();
    }
}

