/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.utils.helpers;

import boilerplate.common.baseclasses.blocks.BaseBlock;
import boilerplate.common.baseclasses.items.BaseItem;
import boilerplate.common.baseclasses.items.ItemBlockDesc;
import boilerplate.common.baseclasses.items.ItemBlockDescMeta;
import boilerplate.common.utils.Utils;
import boilerplate.common.utils.entity.KeyValue;
import boilerplate.common.utils.entity.ModWithEntityList;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;

public class RegistryHelper {
    private static ArrayList<ModWithEntityList> entityArrayList = new ArrayList();

    public static void registerAndCreateBasicItem(Item itemField) {
        itemField = new BaseItem();
        RegistryHelper.registerItem(itemField);
    }

    public static void registerAndCreateBasicBlock(Block blockField, Material mat, String name) {
        blockField = new BaseBlock(mat);
        GameRegistry.registerBlock((Block)blockField, (String)name);
    }

    public static void registerItem(Item item) {
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
    }

    public static void registerBlockWithDesc(Block block, String name) {
        GameRegistry.registerBlock((Block)block, ItemBlockDesc.class, (String)name);
    }

    public static void registerContainerBlock(Block block, Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerBlock((Block)block, (String)name);
        String id = "TE" + name.substring(5);
        GameRegistry.registerTileEntity(tile, (String)id);
    }

    public static void registerContainerBlockWithDesc(Block block, Class<? extends TileEntity> tile, String name) {
        RegistryHelper.registerBlockWithDesc(block, name);
        GameRegistry.registerTileEntity(tile, (String)("TE" + name.substring(5)));
    }

    public static void registerContainerBlockWithDescAndMeta(Block block, Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerBlock((Block)block, ItemBlockDescMeta.class, (String)name);
        GameRegistry.registerTileEntity(tile, (String)("TE" + name.substring(5)));
    }

    public static void registerArmorSet(Item helm, Item chestplate, Item legs, Item boots, String name, String modid) {
        GameRegistry.registerItem((Item)helm, (String)("ItemHelmet" + name), (String)modid);
        GameRegistry.registerItem((Item)chestplate, (String)("ItemChestplate" + name), (String)modid);
        GameRegistry.registerItem((Item)legs, (String)("ItemLegs" + name), (String)modid);
        GameRegistry.registerItem((Item)boots, (String)("ItemBoots" + name), (String)modid);
    }

    public static void registerToolSet(Item sword, Item spade, Item pickaxe, Item axe, Item hoe, String name, String modid) {
        GameRegistry.registerItem((Item)sword, (String)("ItemSword" + name), (String)modid);
        GameRegistry.registerItem((Item)spade, (String)("ItemShovel" + name), (String)modid);
        GameRegistry.registerItem((Item)pickaxe, (String)("ItemPickaxe" + name), (String)modid);
        GameRegistry.registerItem((Item)axe, (String)("ItemAxe" + name), (String)modid);
        GameRegistry.registerItem((Item)hoe, (String)("ItemHoe" + name), (String)modid);
    }

    public static void addToEntityArrayList(String modid, Configuration configuration) {
        RegistryHelper.addToEntityArrayList(new ModWithEntityList(modid, configuration));
    }

    public static void addToEntityArrayList(ModWithEntityList modWithEntityList) {
        entityArrayList.add(modWithEntityList);
    }

    public static ModWithEntityList getFromEntityArrayList(String modid) {
        for (ModWithEntityList modWithEntityList : entityArrayList) {
            if (!modWithEntityList.getModName().equals(modid)) continue;
            return modWithEntityList;
        }
        return null;
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String name) {
        int entityID = RegistryHelper.getEntityID(Utils.getCurrentMod().getID(), name);
        EntityRegistry.registerModEntity(entityClass, (String)name, (int)entityID, (Object)Utils.getCurrentMod(), (int)64, (int)1, (boolean)true);
    }

    private static int getEntityID(String modid, String entityName) {
        Iterator<ModWithEntityList> i$ = entityArrayList.iterator();
        if (i$.hasNext()) {
            ModWithEntityList modWithEntityList = i$.next();
            if (modWithEntityList.getModName().equals(modid)) {
                for (KeyValue<String, Integer> entityNameAndID : modWithEntityList.getEntityList()) {
                    if (!entityNameAndID.getKey().equals(entityName)) continue;
                    return entityNameAndID.getValue();
                }
            }
            return modWithEntityList.getNextAvailableID();
        }
        ArrayList<KeyValue<String, Integer>> newEntityArrayList = new ArrayList<KeyValue<String, Integer>>();
        newEntityArrayList.add(new KeyValue<String, Integer>(entityName, 0));
        ModWithEntityList newModWithEntityList = new ModWithEntityList(modid, newEntityArrayList, 0);
        RegistryHelper.addToEntityArrayList(newModWithEntityList);
        return RegistryHelper.getEntityID(modid, entityName);
    }
}

