/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.utils;

import boilerplate.common.IBoilerplateMod;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Array;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class Utils {
    public static final Random RANDOM = new Random();

    public static int randInt(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static void playSFX(World world, int x, int y, int z, String sound) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
    }

    public static boolean canPlayerBreakBlock(World world, EntityPlayer player, int x, int y, int z) {
        return !Utils.getBlockUnbreakable(world, x, y, z) && player.field_71075_bZ.field_75099_e;
    }

    public static boolean getBlockUnbreakable(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z).func_149712_f(world, x, y, z) == -1.0f;
    }

    public static void spawnEntityAtCoords(World world, Entity entity, int x, int y, int z) {
        EntityLiving entityliving = (EntityLiving)entity;
        entity.func_70012_b((double)x, (double)y, (double)z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entityliving.field_70759_as = entityliving.field_70177_z;
        entityliving.field_70761_aq = entityliving.field_70177_z;
        world.func_72838_d(entity);
        entityliving.func_70642_aH();
    }

    public static <T> T[] merge(T[] ... arrays) {
        int arrCount = 0;
        int count = 0;
        for (T[] array : arrays) {
            ++arrCount;
            count += array.length;
        }
        Object[] mergedArray = (Object[])Array.newInstance(arrays[0][0].getClass(), count);
        int start = 0;
        for (T[] array : arrays) {
            System.arraycopy(array, 0, mergedArray, start, array.length);
            start += array.length;
        }
        return mergedArray;
    }

    public static IBoilerplateMod getCurrentMod() {
        Object activeMod = Loader.instance().activeModContainer().getMod();
        if (activeMod instanceof IBoilerplateMod) {
            return (IBoilerplateMod)activeMod;
        }
        FMLLog.bigWarning((String)"Mods using Boilerplate Lib baseclasses must have their main class extend IBoilerplateMod!", (Object[])new Object[]{""});
        return null;
    }
}

