/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.utils;

import boilerplate.common.utils.ItemStackUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ToolUtils {
    public static boolean toolsSetup = false;
    public static HashMap<String, Class> toolClasses;

    public static boolean isItemATool(ItemStack itemStack) {
        boolean isTool = false;
        if (ItemStackUtils.isItemNonNull(itemStack)) {
            if (itemStack.func_77973_b().getToolClasses(itemStack).contains("IE_HAMMER")) {
                isTool = true;
            }
            if (!isTool) {
                if (!toolsSetup) {
                    ToolUtils.setupToolItems();
                }
                for (Map.Entry<String, Class> entry : toolClasses.entrySet()) {
                    if (!ItemStackUtils.isItemInstanceOf(itemStack, entry.getValue())) continue;
                    isTool = true;
                    break;
                }
            }
        }
        return isTool;
    }

    public static void setupToolItems() {
        HashMap<String, String> classStrings = new HashMap<String, String>();
        classStrings.put("BC Wrench", "buildcraft.api.tools.IToolWrench");
        classStrings.put("TE Hammer", "cofh.api.item.IToolHammer");
        classStrings.put("RC Crowbar", "mods.railcraft.api.core.items.IToolCrowbar");
        classStrings.put("MFR Hammer", "powercrystals.minefactoryreloaded.api.IMFRHammer");
        classStrings.put("AE Wrench", "appeng.api.implementations.items.IAEWrench");
        toolClasses = new HashMap();
        for (Map.Entry entry : classStrings.entrySet()) {
            try {
                Class<?> toolClass = Class.forName((String)entry.getValue());
                if (toolClass == null) continue;
                toolClasses.put((String)entry.getKey(), toolClass);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        toolsSetup = true;
    }
}

