/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.tiles;

import boilerplate.api.IBlockOverlayText;
import boilerplate.common.Boilerplate;
import boilerplate.common.blocks.SideType;
import boilerplate.common.tiles.TileEntityBase;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntitySided
extends TileEntityBase
implements IBlockOverlayText {
    private SideType[] sideConfig = new SideType[6];

    public TileEntitySided() {
        Arrays.fill((Object[])this.sideConfig, (Object)SideType.NONE);
    }

    public void toggleSide(int side) {
        int type = this.sideConfig[side].ordinal();
        if (++type >= SideType.values().length || type < 0) {
            type = 0;
        }
        this.sideConfig[side] = SideType.values()[type];
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, 0);
    }

    public void setSideConfig(int side, SideType sideType) {
        this.sideConfig[side] = sideType;
    }

    public SideType getSideValue(int side) {
        return this.sideConfig[side];
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbtTagCompound) {
        int[] array = nbtTagCompound.func_74759_k("sideConfig");
        if (this.sideConfig == null) {
            this.sideConfig = new SideType[6];
        }
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                this.sideConfig[i] = SideType.values()[array[i]];
            }
        }
    }

    @Override
    public void writeToNBTCustom(NBTTagCompound nbtTagCompound) {
        int[] array = new int[6];
        for (int i = 0; i < this.sideConfig.length; ++i) {
            array[i] = this.sideConfig[i].ordinal();
        }
        nbtTagCompound.func_74783_a("sideConfig", array);
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return true;
        }
        return false;
    }

    public void sendBlockUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, MovingObjectPosition mop, boolean tool) {
        if (tool && Boilerplate.colorblind) {
            SideType facing = this.sideConfig[Math.min(this.sideConfig.length - 1, mop.field_72310_e)];
            SideType opposite = this.sideConfig[Math.min(this.sideConfig.length - 1, ForgeDirection.OPPOSITES[mop.field_72310_e])];
            return new String[]{Boilerplate.proxy.translate("blockSide.facing") + ": " + Boilerplate.proxy.translate("sidetype." + facing.name().toLowerCase()), Boilerplate.proxy.translate("blockSide.opposite") + ": " + Boilerplate.proxy.translate("sidetype." + opposite.name().toLowerCase())};
        }
        return null;
    }
}

