/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.modcompat;

import boilerplate.common.Boilerplate;
import boilerplate.common.modcompat.ModCompat;
import boilerplate.common.utils.ILogger;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;

public class CompatibilityHandler {
    ILogger logger;
    private HashMap<String, ModCompat> modCompatEnabled = new HashMap();

    public CompatibilityHandler() {
        this(Boilerplate.logger);
    }

    public CompatibilityHandler(ILogger logger) {
        this.logger = logger;
    }

    @Deprecated
    public ArrayList<ModCompat> getModCompat() {
        ArrayList<ModCompat> arrayList = new ArrayList<ModCompat>();
        for (Map.Entry<String, ModCompat> entry : this.modCompatEnabled.entrySet()) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    public HashMap<String, ModCompat> getModCompatEnabled() {
        return this.modCompatEnabled;
    }

    public void addModCompat(ModCompat modCompat) {
        this.modCompatEnabled.put(modCompat.getName(), modCompat);
    }

    public void preInit(FMLPreInitializationEvent event) {
        for (ModCompat modCompat : this.getModCompatEnabled().values()) {
            if (!modCompat.areRequirementsMet() && modCompat.getIsActive().booleanValue()) {
                modCompat.setIsActive(false);
                this.logger.error("Requirements are not met for " + modCompat.getName() + ". Deactivating");
            }
            if (!modCompat.getIsActive().booleanValue()) continue;
            this.logger.info("Loading " + modCompat.getName() + " module");
        }
        for (ModCompat modCompat : this.getModCompatEnabled().values()) {
            if (!modCompat.getIsActive().booleanValue()) continue;
            modCompat.preInit(event);
        }
    }

    public void init(FMLInitializationEvent event) {
        for (ModCompat modCompat : this.getModCompatEnabled().values()) {
            if (!modCompat.getIsActive().booleanValue()) continue;
            modCompat.init(event);
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        for (ModCompat modCompat : this.getModCompatEnabled().values()) {
            if (!modCompat.getIsActive().booleanValue()) continue;
            modCompat.postInit(event);
        }
    }

    public void clientInit(FMLInitializationEvent event) {
        for (ModCompat modCompat : this.getModCompatEnabled().values()) {
            if (!modCompat.getIsActive().booleanValue()) continue;
            modCompat.clientInit(event);
        }
    }

    public Configuration configureModCompat(Configuration configuration) {
        for (ModCompat modCompat : this.getModCompatEnabled().values()) {
            modCompat.setIsActive(configuration.get("ModCompat", modCompat.getName() + " Enabled", true).getBoolean(true));
        }
        return configuration;
    }
}

