/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.blocks;

import boilerplate.common.blocks.SideType;
import boilerplate.common.tiles.TileEntitySided;
import boilerplate.common.utils.ToolUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class SidedBlock
extends BlockContainer {
    public IIcon[] topIcons = new IIcon[3];
    public IIcon[] sideIcons = new IIcon[3];

    protected SidedBlock(Material material) {
        super(material);
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntitySided && !world.field_72995_K) {
            TileEntitySided tileEntitySided = (TileEntitySided)te;
            if (ToolUtils.isItemATool(player.func_71045_bC())) {
                if (player.func_70093_af()) {
                    side = ForgeDirection.OPPOSITES[side];
                }
                tileEntitySided.toggleSide(side);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void func_149651_a(IIconRegister var1);

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntitySided tileEntitySided = (TileEntitySided)world.func_147438_o(x, y, z);
        if (blockSide < 2) {
            return this.topIcons[tileEntitySided.getSideValue(blockSide).ordinal()];
        }
        return this.sideIcons[tileEntitySided.getSideValue(blockSide).ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side < 2) {
            return this.topIcons[SideType.NONE.ordinal()];
        }
        return this.sideIcons[SideType.NONE.ordinal()];
    }
}

