/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.baseclasses.items.tools;

import boilerplate.common.baseclasses.items.BaseItem;
import boilerplate.common.baseclasses.items.tools.BaseSword;
import boilerplate.common.utils.ItemStackUtils;
import boilerplate.common.utils.helpers.MaterialHelper;
import com.google.common.collect.Multimap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class BaseTool
extends BaseItem {
    public static final int steamForRepair = 20;
    public float efficiencyOnProperMaterial = 4.0f;
    public float damageVsEntity;
    protected Item.ToolMaterial toolMaterial;

    protected BaseTool(float damage, Item.ToolMaterial toolMat) {
        super("tools/");
        this.toolMaterial = toolMat;
        this.func_77625_d(1);
        this.efficiencyOnProperMaterial = toolMat.func_77998_b();
        this.damageVsEntity = damage + toolMat.func_78000_c();
        this.func_77664_n();
        this.func_77656_e(toolMat.func_77997_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List l) {
        l.add(new ItemStack(item, 1));
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (block.getHarvestLevel(meta) <= this.toolMaterial.func_77996_d()) {
            for (String elem : this.getToolClasses(stack)) {
                if (block.isToolEffective(elem, meta)) {
                    return this.efficiencyOnProperMaterial;
                }
                Material mat = block.func_149688_o();
                for (Material m : MaterialHelper.getMaterialForTool(elem)) {
                    if (m != mat) continue;
                    return this.efficiencyOnProperMaterial;
                }
            }
        }
        return 1.0f;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.getDigSpeed(stack, block, 0) > 1.0f;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase living1, EntityLivingBase living2) {
        if (this instanceof BaseSword) {
            itemstack.func_77972_a(1, living2);
        } else {
            itemstack.func_77972_a(2, living2);
        }
        return true;
    }

    public int func_77619_b() {
        return this.toolMaterial.func_77995_e();
    }

    public boolean func_150894_a(ItemStack stack, World p_150894_2_, Block p_150894_3_, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase living) {
        stack.func_77972_a(1, living);
        return true;
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean bool) {
        if (!(this instanceof BaseSword)) {
            list.add("Efficiency: " + this.toolMaterial.func_77998_b());
        }
    }

    protected void changeToolDamage(ItemStack itemStack, double damage) {
        ItemStackUtils.addModifier(itemStack, SharedMonsterAttributes.field_111264_e.func_111108_a(), damage, 0);
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.damageVsEntity, 0));
        return multimap;
    }
}

