/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.common.baseclasses.items.electric;

import boilerplate.api.IEnergyItem;
import boilerplate.common.baseclasses.items.BaseItem;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class BaseElectricItem
extends BaseItem
implements IEnergyItem {
    protected int maxEnergy;
    protected short maxReceive;
    protected short maxSend;

    public BaseElectricItem(int maxEnergy, int maxReceive, int maxSend) {
        this.maxEnergy = maxEnergy * 1000;
        this.maxReceive = (short)maxReceive;
        this.maxSend = (short)maxSend;
        this.func_77625_d(1);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(this.getUnchargedItem(item));
        list.add(this.getChargedItem(item));
    }

    public ItemStack getUnchargedItem(Item item) {
        ItemStack uncharged = new ItemStack(item);
        if (!uncharged.func_77942_o()) {
            uncharged.func_77982_d(new NBTTagCompound());
        }
        uncharged.func_77978_p().func_74768_a("energy", 0);
        return uncharged.func_77946_l();
    }

    public ItemStack getChargedItem(Item item) {
        ItemStack charged = new ItemStack(item);
        if (!charged.func_77942_o()) {
            charged.func_77982_d(new NBTTagCompound());
        }
        charged.func_77978_p().func_74768_a("energy", this.maxEnergy);
        return charged.func_77946_l();
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add("Energy: " + this.getEnergyStored(stack) / 1000 + "k / " + this.maxEnergy / 1000 + "k");
        if (this.maxSend > 0 && this.maxReceive > 0) {
            list.add("Transfer(in/out): " + this.maxReceive + " / " + this.maxSend);
        } else if (this.maxReceive > 0) {
            list.add("Transfer(in): " + this.maxReceive);
        } else if (this.maxSend > 0) {
            list.add("Transfer(out): " + this.maxSend);
        }
    }

    public void func_77622_d(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setEnergy(stack, 0);
    }

    public void setEnergy(ItemStack stack, int energy) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (energy < 0) {
            energy = 0;
        }
        if (energy > this.maxEnergy) {
            energy = this.maxEnergy;
        }
        tag.func_74768_a("energy", energy);
        stack.func_77982_d(tag);
    }

    @Override
    public int receiveEnergy(ItemStack itemStack, int maxReceive, boolean simulate) {
        int received = Math.min(this.maxEnergy - this.getEnergyStored(itemStack), maxReceive);
        received = Math.min(received, this.maxReceive);
        if (!simulate) {
            this.setEnergy(itemStack, this.getEnergyStored(itemStack) + received);
        }
        return received;
    }

    @Override
    public int extractEnergy(ItemStack itemStack, int maxExtract, boolean simulate) {
        int extracted = Math.min(this.getEnergyStored(itemStack), maxExtract);
        extracted = Math.min(extracted, this.maxSend);
        if (!simulate) {
            this.setEnergy(itemStack, this.getEnergyStored(itemStack) - extracted);
        }
        return extracted;
    }

    @Override
    public int getEnergyStored(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74762_e("energy");
        }
        this.setEnergy(itemStack, 0);
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }

    @Override
    public short getMaxSend() {
        return this.maxSend;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

