/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.client.fx;

import boilerplate.client.ClientHelper;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FXRaygun
extends EntityFX {
    public int particle = 16;
    EntityPlayer player = null;
    private double offset = 0.0;
    private float length = 0.0f;
    private float rotYaw = 0.0f;
    private float rotPitch = 0.0f;
    private float prevYaw = 0.0f;
    private float prevPitch = 0.0f;
    private double tX = 0.0;
    private double tY = 0.0;
    private double tZ = 0.0;
    private double ptX = 0.0;
    private double ptY = 0.0;
    private double ptZ = 0.0;
    private int type = 0;
    private float endMod = 1.0f;
    private boolean reverse = false;
    private boolean pulse = true;
    private int rotationspeed = 5;
    private float prevSize = 0.0f;
    public int impact;
    private static final ResourceLocation rayTex = new ResourceLocation("steamcraft:textures/misc/ray.png");
    public static boolean amITooLazyToLearnTheUntiCircle = true;

    public FXRaygun(World world, EntityPlayer player, double tx, double ty, double tz, float red, float green, float blue, int age) {
        super(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0);
        if (player.getEntityData() != ClientHelper.viewEntity().getEntityData()) {
            this.offset = (double)(player.field_70131_O / 2.0f) + 0.25;
        }
        this.field_70552_h = red;
        this.field_70553_i = green;
        this.field_70551_j = blue;
        this.player = player;
        this.func_70105_a(0.02f, 0.02f);
        this.field_70145_X = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.tX = tx;
        this.tY = ty;
        this.tZ = tz;
        float xd = (float)(player.field_70165_t - this.tX);
        float yd = (float)(player.field_70163_u + this.offset - this.tY);
        float zd = (float)(player.field_70161_v - this.tZ);
        this.length = MathHelper.func_76129_c((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.field_70547_e = age;
        EntityLivingBase renderentity = ClientHelper.viewEntity();
        int visibleDistance = 50;
        if (!ClientHelper.settings().field_74347_j) {
            visibleDistance = 25;
        }
        if (renderentity.func_70011_f(player.field_70165_t, player.field_70163_u, player.field_70161_v) > (double)visibleDistance) {
            this.field_70547_e = 0;
        }
    }

    public void updateRay(double x, double y, double z) {
        this.tX = x;
        this.tY = y;
        this.tZ = z;
        while (this.field_70547_e - this.field_70546_d < 4) {
            ++this.field_70547_e;
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.player.field_70165_t;
        this.field_70167_r = this.player.field_70163_u + this.offset;
        this.field_70166_s = this.player.field_70161_v;
        this.ptX = this.tX;
        this.ptY = this.tY;
        this.ptZ = this.tZ;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        float xd = (float)(this.player.field_70165_t - this.tX);
        float yd = (float)(this.player.field_70163_u + this.offset - this.tY);
        float zd = (float)(this.player.field_70161_v - this.tZ);
        this.length = MathHelper.func_76129_c((float)(xd * xd + yd * yd + zd * zd));
        double var7 = MathHelper.func_76133_a((double)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, var7) * 180.0 / Math.PI);
        while (this.rotPitch - this.prevPitch < -180.0f) {
            this.prevPitch -= 360.0f;
        }
        while (this.rotPitch - this.prevPitch >= 180.0f) {
            this.prevPitch += 360.0f;
        }
        while (this.rotYaw - this.prevYaw < -180.0f) {
            this.prevYaw -= 360.0f;
        }
        while (this.rotYaw - this.prevYaw >= 180.0f) {
            this.prevYaw += 360.0f;
        }
        if (this.impact > 0) {
            --this.impact;
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    public void setRGB(float r, float g, float b) {
        this.field_70552_h = r;
        this.field_70553_i = g;
        this.field_70551_j = b;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setEndMod(float endMod) {
        this.endMod = endMod;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setPulse(boolean pulse) {
        this.pulse = pulse;
    }

    public void setRotationspeed(int rotationspeed) {
        this.rotationspeed = rotationspeed;
    }

    public void func_70539_a(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        float var9 = 1.0f;
        float slide = this.field_70170_p.func_72820_D();
        float rot = (float)(this.field_70170_p.field_73011_w.getWorldTime() % (long)(360 / this.rotationspeed) * (long)this.rotationspeed) + (float)this.rotationspeed * f;
        float size = 0.5f;
        if (this.pulse) {
            size = Math.min((float)this.field_70546_d / 4.0f, 1.0f);
            size = this.prevSize + (size - this.prevSize) * f;
        }
        float op = 0.4f;
        if (this.pulse && this.field_70547_e - this.field_70546_d <= 4) {
            op = 0.4f - (float)(4 - (this.field_70547_e - this.field_70546_d)) * 0.1f;
        }
        switch (this.type) {
            default: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ClientHelper.textureManager().func_110577_a(rayTex);
            }
        }
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2884);
        float var11 = slide + f;
        if (this.reverse) {
            var11 *= -1.0f;
        }
        float var12 = -var11 * 0.2f - (float)MathHelper.func_76141_d((float)(-var11 * 0.1f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        double prex = this.player.field_70169_q;
        double prey = this.player.field_70167_r + this.offset;
        double prez = this.player.field_70166_s;
        double px = this.player.field_70165_t;
        double py = this.player.field_70163_u + this.offset;
        double pz = this.player.field_70161_v;
        prex -= (double)(MathHelper.func_76134_b((float)(this.player.field_70126_B / 180.0f * 3.141593f)) * 0.066f);
        prey -= 0.06;
        prez -= (double)(MathHelper.func_76126_a((float)(this.player.field_70126_B / 180.0f * 3.141593f)) * 0.04f);
        Vec3 vec3d = this.player.func_70676_i(1.0f);
        prex += vec3d.field_72450_a * 0.3;
        prey += vec3d.field_72448_b * 0.3;
        prez += vec3d.field_72449_c * 0.3;
        px -= (double)(MathHelper.func_76134_b((float)(this.player.field_70177_z / 180.0f * 3.141593f)) * 0.066f);
        py -= 0.06;
        pz -= (double)(MathHelper.func_76126_a((float)(this.player.field_70177_z / 180.0f * 3.141593f)) * 0.04f);
        vec3d = this.player.func_70676_i(1.0f);
        float xx = (float)(prex + ((px += vec3d.field_72450_a * 0.3) - prex) * (double)f - EntityFX.field_70556_an);
        float yy = (float)(prey + ((py += vec3d.field_72448_b * 0.3) - prey) * (double)f - EntityFX.field_70554_ao);
        float zz = (float)(prez + ((pz += vec3d.field_72449_c * 0.3) - prez) * (double)f - EntityFX.field_70555_ap);
        GL11.glTranslated((double)xx, (double)yy, (double)zz);
        float ry = this.prevYaw + (this.rotYaw - this.prevYaw) * f;
        float rp = this.prevPitch + (this.rotPitch - this.prevPitch) * f;
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(180.0f + ry), (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)rp, (float)1.0f, (float)0.0f, (float)0.0f);
        double var44 = -0.15 * (double)size;
        double var17 = 0.15 * (double)size;
        double var44b = -0.15 * (double)size * (double)this.endMod;
        double var17b = 0.15 * (double)size * (double)this.endMod;
        GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
        for (int t = 0; t < 5; ++t) {
            double var29 = this.length * size * 1.0f;
            double var31 = 0.0;
            double var33 = 1.0;
            double var35 = -1.0f + var12 + (float)t / 3.0f;
            double var37 = (double)(this.length * size * 1.0f) + var35;
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78380_c(200);
            tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, op);
            tessellator.func_78374_a(var44b, var29, 0.0, 1.0, var37);
            tessellator.func_78374_a(var44, 0.0, 0.0, 1.0, var35);
            tessellator.func_78374_a(var17, 0.0, 0.0, 0.0, var35);
            tessellator.func_78374_a(var17b, var29, 0.0, 0.0, var37);
            tessellator.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        tessellator.func_78382_b();
        this.prevSize = size;
    }
}

