/*
 * Decompiled with CFR 0.152.
 */
package boilerplate.client;

import boilerplate.api.IToolTipSlot;
import boilerplate.client.utils.GuiColors;
import boilerplate.common.baseclasses.BaseTileWithInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class BaseContainerGui
extends GuiContainer {
    protected BaseTileWithInventory tile;

    public BaseContainerGui(Container p_i1072_1_) {
        super(p_i1072_1_);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (this.tile == null) {
            return;
        }
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof IToolTipSlot) || slot.func_75216_d() || !this.mouseInside(slot, mouseX - x, mouseY - y) || slot.field_75222_d >= this.tile.func_70302_i_()) continue;
            this.func_146283_a(Lists.newArrayList((Object[])new String[]{StatCollector.func_74838_a((String)((IToolTipSlot)slot).getSlotTooltipUnloc())}), mouseX - x, mouseY - y);
        }
    }

    private boolean mouseInside(Slot slot, int x, int y) {
        return x >= slot.field_75223_e && x <= slot.field_75223_e + 16 && y >= slot.field_75221_f && y <= slot.field_75221_f + 16;
    }

    protected void drawFluidInfo(FluidTank tank, int x, int y) {
        ArrayList<String> lines = new ArrayList<String>();
        FluidStack fluidstack = tank.getFluid();
        if (fluidstack == null) {
            lines.add((Object)((Object)GuiColors.RED) + "Empty");
        } else if (fluidstack.getFluid() == FluidRegistry.WATER) {
            lines.add((Object)((Object)GuiColors.LIGHTBLUE) + "Water");
        } else if (fluidstack.getFluid() == FluidRegistry.getFluid((String)"steam")) {
            lines.add((Object)((Object)GuiColors.GRAY) + "Steam");
        } else {
            lines.add((Object)((Object)GuiColors.GREEN) + fluidstack.getLocalizedName());
        }
        lines.add(tank.getFluidAmount() + "/" + tank.getCapacity());
        this.drawHoveringText(lines, x - this.field_147003_i, y - this.field_147009_r, this.field_146289_q);
    }

    protected void drawFluid(Fluid fluid, int level, int x, int y, int width, int height) {
        if (fluid == null) {
            return;
        }
        IIcon icon = fluid.getIcon();
        if (icon == null) {
            icon = fluid.getBlock().func_149691_a(0, 0);
        }
        if (icon != null) {
            int i;
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int fullX = width / 16;
            int fullY = height / 16;
            int lastX = width - fullX * 16;
            int lastY = height - fullY * 16;
            int fullLvl = (height - level) / 16;
            int lastLvl = height - level - fullLvl * 16;
            for (i = 0; i < fullX; ++i) {
                for (int j = 0; j < fullY; ++j) {
                    if (j < fullLvl) continue;
                    this.drawCutIcon(icon, x + i * 16, y + j * 16, 16, 16, j == fullLvl ? lastLvl : 0);
                }
            }
            for (i = 0; i < fullX; ++i) {
                this.drawCutIcon(icon, x + i * 16, y + fullY * 16, 16, lastY, fullLvl == fullY ? lastLvl : 0);
            }
            for (i = 0; i < fullY; ++i) {
                if (i < fullLvl) continue;
                this.drawCutIcon(icon, x + fullX * 16, y + i * 16, lastX, 16, i == fullLvl ? lastLvl : 0);
            }
            this.drawCutIcon(icon, x + fullX * 16, y + fullY * 16, lastX, lastY, fullLvl == fullY ? lastLvl : 0);
        }
    }

    private void drawCutIcon(IIcon icon, int x, int y, int width, int height, int cut) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a((double)x, (double)(y + height), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)height));
        tess.func_78374_a((double)(x + width), (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94214_a((double)width), (double)icon.func_94207_b((double)cut));
        tess.func_78374_a((double)x, (double)(y + cut), (double)this.field_73735_i, (double)icon.func_94209_e(), (double)icon.func_94207_b((double)cut));
        tess.func_78381_a();
    }
}

