/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib.github;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import latmod.lib.github.GitHubBranch;
import latmod.lib.github.GitHubFile;
import latmod.lib.net.LMURLConnection;
import latmod.lib.net.RequestMethod;
import latmod.lib.util.FinalIDObject;

public class GitHubCommit
extends FinalIDObject {
    public final GitHubBranch branch;
    public final String info;
    public final String treeURL;
    private Map<String, GitHubFile.Blob> files;

    public GitHubCommit(GitHubBranch b, JsonObject o) {
        super(o.get("sha").getAsString());
        o = o.get("commit").getAsJsonObject();
        this.info = o.get("message").getAsString();
        this.treeURL = o.get("tree").getAsJsonObject().get("url").getAsString();
        this.branch = b;
    }

    @Override
    public String toString() {
        return this.info.isEmpty() ? this.getID() : this.info;
    }

    public Map<String, GitHubFile.Blob> getFiles() throws Exception {
        if (this.files == null) {
            LinkedHashMap<String, GitHubFile.Blob> map = new LinkedHashMap<String, GitHubFile.Blob>();
            for (JsonElement e : new LMURLConnection(RequestMethod.SIMPLE_GET, this.treeURL).connect().asJson().getAsJsonObject().get("tree").getAsJsonArray()) {
                this.addToTree(map, GitHubFile.getFrom(this, null, e.getAsJsonObject()));
            }
            this.files = Collections.unmodifiableMap(map);
        }
        return this.files;
    }

    private void addToTree(Map<String, GitHubFile.Blob> map, GitHubFile file) throws Exception {
        if (file instanceof GitHubFile.Tree) {
            JsonObject o = new LMURLConnection(RequestMethod.SIMPLE_GET, file.url).connect().asJson().getAsJsonObject();
            for (JsonElement e : o.get("tree").getAsJsonArray()) {
                this.addToTree(map, GitHubFile.getFrom(this, file, e.getAsJsonObject()));
            }
        } else {
            map.put(file.getID(), (GitHubFile.Blob)file);
        }
    }

    public String getFilePath(String s) {
        return "https://raw.githubusercontent.com/" + this.branch.repo.getID() + "/" + this.getID() + "/" + s;
    }
}

