/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.mod.cmd;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.FTBLib;
import ftb.lib.api.cmd.CommandLM;
import ftb.lib.api.cmd.CommandLevel;
import ftb.lib.api.cmd.ICustomCommandInfo;
import ftb.lib.api.notification.ClickAction;
import ftb.lib.api.notification.ClickActionType;
import ftb.lib.api.notification.MouseAction;
import ftb.lib.api.notification.Notification;
import java.util.List;
import latmod.lib.LMJsonUtils;
import latmod.lib.LMStringUtils;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CmdNotify
extends CommandLM
implements ICustomCommandInfo {
    public CmdNotify() {
        super("ftb_notify", CommandLevel.OP);
    }

    @Override
    public String func_71518_a(ICommandSender ics) {
        return "/" + this.commandName + " <player|@a> <json...>";
    }

    @Override
    public String[] getTabStrings(ICommandSender ics, String[] args, int i) throws CommandException {
        if (i == 1) {
            return new String[]{"{\"id\":\"test\", \"title\":\"Title\", \"mouse\":{}}"};
        }
        return super.getTabStrings(ics, args, i);
    }

    @Override
    public Boolean getUsername(String[] args, int i) {
        return i == 0 ? Boolean.TRUE : null;
    }

    @Override
    public IChatComponent onCommand(ICommandSender ics, String[] args) throws CommandException {
        CmdNotify.checkArgs(args, 2);
        String s = LMStringUtils.unsplitSpaceUntilEnd(1, args);
        try {
            Notification n = Notification.deserialize(LMJsonUtils.fromJson(s));
            if (n != null) {
                for (EntityPlayerMP ep : CmdNotify.findPlayers(ics, args[0])) {
                    FTBLib.notifyPlayer(ep, n);
                }
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CmdNotify.error((IChatComponent)new ChatComponentText("Invalid notification: " + s));
    }

    @Override
    public void addInfo(List<IChatComponent> list, ICommandSender sender) {
        list.add((IChatComponent)new ChatComponentText("/" + this.commandName));
        list.add(null);
        list.add((IChatComponent)new ChatComponentText("Example:"));
        list.add(null);
        Notification n = new Notification("example_id", (IChatComponent)new ChatComponentText("Example title"), 6500);
        n.setColor(-65536);
        n.setItem(new ItemStack(Items.field_151034_e, 10));
        MouseAction ma = new MouseAction();
        ma.click = new ClickAction(ClickActionType.CMD, (JsonElement)new JsonPrimitive("reload"));
        n.setMouseAction(ma);
        n.setDesc((IChatComponent)new ChatComponentText("Example description"));
        for (String s : LMJsonUtils.toJson(LMJsonUtils.getGson(true), n.func_151003_a()).split("\n")) {
            list.add((IChatComponent)new ChatComponentText(s));
        }
        list.add(null);
        list.add((IChatComponent)new ChatComponentText("Only \"id\" and \"title\" are required, the rest is optional"));
        list.add((IChatComponent)new ChatComponentText("\"mouse\":{} will make it permanent"));
    }
}

