/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2.lib;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.mod.luaj.vm2.Buffer;
import org.mod.luaj.vm2.Globals;
import org.mod.luaj.vm2.LuaTable;
import org.mod.luaj.vm2.LuaValue;
import org.mod.luaj.vm2.Varargs;
import org.mod.luaj.vm2.lib.TwoArgFunction;
import org.mod.luaj.vm2.lib.VarArgFunction;

public class OsLib
extends TwoArgFunction {
    public static String TMP_PREFIX = ".luaj";
    public static String TMP_SUFFIX = "tmp";
    private static final int CLOCK = 0;
    private static final int DATE = 1;
    private static final int DIFFTIME = 2;
    private static final int EXECUTE = 3;
    private static final int EXIT = 4;
    private static final int GETENV = 5;
    private static final int REMOVE = 6;
    private static final int RENAME = 7;
    private static final int SETLOCALE = 8;
    private static final int TIME = 9;
    private static final int TMPNAME = 10;
    private static final String[] NAMES = new String[]{"clock", "date", "difftime", "execute", "exit", "getenv", "remove", "rename", "setlocale", "time", "tmpname"};
    private static final long t0;
    private static long tmpnames;
    protected Globals globals;
    private static final String[] WeekdayNameAbbrev;
    private static final String[] WeekdayName;
    private static final String[] MonthNameAbbrev;
    private static final String[] MonthName;

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        this.globals = env.checkglobals();
        LuaTable os = new LuaTable();
        for (int i = 0; i < NAMES.length; ++i) {
            os.set(NAMES[i], (LuaValue)new OsLibFunc(i, NAMES[i]));
        }
        env.set("os", (LuaValue)os);
        env.get("package").get("loaded").set("os", (LuaValue)os);
        return os;
    }

    protected double clock() {
        return (double)(System.currentTimeMillis() - t0) / 1000.0;
    }

    protected double difftime(double t2, double t1) {
        return t2 - t1;
    }

    public String date(String format2, double time) {
        Calendar d = Calendar.getInstance();
        d.setTime(new Date((long)(time * 1000.0)));
        if (format2.startsWith("!")) {
            d.setTime(new Date((long)((time -= (double)this.timeZoneOffset(d)) * 1000.0)));
            format2 = format2.substring(1);
        }
        byte[] fmt = format2.getBytes();
        int n = fmt.length;
        Buffer result = new Buffer(n);
        int i = 0;
        block28: while (i < n) {
            byte c = fmt[i++];
            switch (c) {
                case 10: {
                    result.append("\n");
                    continue block28;
                }
                default: {
                    result.append(c);
                    continue block28;
                }
                case 37: 
            }
            if (i >= n) continue;
            c = fmt[i++];
            switch (c) {
                default: {
                    LuaValue.argerror(1, "invalid conversion specifier '%" + c + "'");
                    continue block28;
                }
                case 37: {
                    result.append((byte)37);
                    continue block28;
                }
                case 97: {
                    result.append(WeekdayNameAbbrev[d.get(7) - 1]);
                    continue block28;
                }
                case 65: {
                    result.append(WeekdayName[d.get(7) - 1]);
                    continue block28;
                }
                case 98: {
                    result.append(MonthNameAbbrev[d.get(2)]);
                    continue block28;
                }
                case 66: {
                    result.append(MonthName[d.get(2)]);
                    continue block28;
                }
                case 99: {
                    result.append(this.date("%a %b %d %H:%M:%S %Y", time));
                    continue block28;
                }
                case 100: {
                    result.append(String.valueOf(100 + d.get(5)).substring(1));
                    continue block28;
                }
                case 72: {
                    result.append(String.valueOf(100 + d.get(11)).substring(1));
                    continue block28;
                }
                case 73: {
                    result.append(String.valueOf(100 + d.get(11) % 12).substring(1));
                    continue block28;
                }
                case 106: {
                    Calendar y0 = this.beginningOfYear(d);
                    int dayOfYear = (int)((d.getTime().getTime() - y0.getTime().getTime()) / 86400000L);
                    result.append(String.valueOf(1001 + dayOfYear).substring(1));
                    continue block28;
                }
                case 109: {
                    result.append(String.valueOf(101 + d.get(2)).substring(1));
                    continue block28;
                }
                case 77: {
                    result.append(String.valueOf(100 + d.get(12)).substring(1));
                    continue block28;
                }
                case 112: {
                    result.append(d.get(11) < 12 ? "AM" : "PM");
                    continue block28;
                }
                case 83: {
                    result.append(String.valueOf(100 + d.get(13)).substring(1));
                    continue block28;
                }
                case 85: {
                    result.append(String.valueOf(this.weekNumber(d, 0)));
                    continue block28;
                }
                case 119: {
                    result.append(String.valueOf((d.get(7) + 6) % 7));
                    continue block28;
                }
                case 87: {
                    result.append(String.valueOf(this.weekNumber(d, 1)));
                    continue block28;
                }
                case 120: {
                    result.append(this.date("%m/%d/%y", time));
                    continue block28;
                }
                case 88: {
                    result.append(this.date("%H:%M:%S", time));
                    continue block28;
                }
                case 121: {
                    result.append(String.valueOf(d.get(1)).substring(2));
                    continue block28;
                }
                case 89: {
                    result.append(String.valueOf(d.get(1)));
                    continue block28;
                }
                case 122: 
            }
            int tzo = this.timeZoneOffset(d) / 60;
            int a = Math.abs(tzo);
            String h = String.valueOf(100 + a / 60).substring(1);
            String m = String.valueOf(100 + a % 60).substring(1);
            result.append((tzo >= 0 ? "+" : "-") + h + m);
        }
        return result.tojstring();
    }

    private Calendar beginningOfYear(Calendar d) {
        Calendar y0 = Calendar.getInstance();
        y0.setTime(d.getTime());
        y0.set(2, 0);
        y0.set(5, 1);
        y0.set(11, 0);
        y0.set(12, 0);
        y0.set(13, 0);
        y0.set(14, 0);
        return y0;
    }

    private int weekNumber(Calendar d, int startDay) {
        Calendar y0 = this.beginningOfYear(d);
        y0.set(5, 1 + (startDay + 8 - y0.get(7)) % 7);
        if (y0.after(d)) {
            y0.set(1, y0.get(1) - 1);
            y0.set(5, 1 + (startDay + 8 - y0.get(7)) % 7);
        }
        long dt = d.getTime().getTime() - y0.getTime().getTime();
        return 1 + (int)(dt / 604800000L);
    }

    private int timeZoneOffset(Calendar d) {
        int localStandarTimeMillis = (d.get(11) * 3600 + d.get(12) * 60 + d.get(13)) * 1000;
        return d.getTimeZone().getOffset(1, d.get(1), d.get(2), d.get(5), d.get(7), localStandarTimeMillis) / 1000;
    }

    private boolean isDaylightSavingsTime(Calendar d) {
        return this.timeZoneOffset(d) != d.getTimeZone().getRawOffset() / 1000;
    }

    protected Varargs execute(String command) {
        return OsLib.varargsOf(NIL, OsLib.valueOf("exit"), ONE);
    }

    protected void exit(int code) {
        System.exit(code);
    }

    protected String getenv(String varname) {
        return System.getProperty(varname);
    }

    protected void remove(String filename) throws IOException {
        throw new IOException("not implemented");
    }

    protected void rename(String oldname, String newname) throws IOException {
        throw new IOException("not implemented");
    }

    protected String setlocale(String locale, String category) {
        return "C";
    }

    protected double time(LuaTable table) {
        Date d;
        if (table == null) {
            d = new Date();
        } else {
            Calendar c = Calendar.getInstance();
            c.set(1, table.get("year").checkint());
            c.set(2, table.get("month").checkint() - 1);
            c.set(5, table.get("day").checkint());
            c.set(11, table.get("hour").optint(12));
            c.set(12, table.get("min").optint(0));
            c.set(13, table.get("sec").optint(0));
            c.set(14, 0);
            d = c.getTime();
        }
        return (double)d.getTime() / 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String tmpname() {
        Class<OsLib> clazz = OsLib.class;
        synchronized (OsLib.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return TMP_PREFIX + tmpnames++ + TMP_SUFFIX;
        }
    }

    static {
        tmpnames = t0 = System.currentTimeMillis();
        WeekdayNameAbbrev = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        WeekdayName = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        MonthNameAbbrev = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        MonthName = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    }

    class OsLibFunc
    extends VarArgFunction {
        public OsLibFunc(int opcode, String name) {
            this.opcode = opcode;
            this.name = name;
        }

        @Override
        public Varargs invoke(Varargs args) {
            try {
                switch (this.opcode) {
                    case 0: {
                        return OsLibFunc.valueOf(OsLib.this.clock());
                    }
                    case 1: {
                        double t;
                        String s = args.optjstring(1, "%c");
                        double d = t = args.isnumber(2) ? args.todouble(2) : OsLib.this.time(null);
                        if (s.equals("*t")) {
                            Calendar d2 = Calendar.getInstance();
                            d2.setTime(new Date((long)(t * 1000.0)));
                            LuaTable tbl = LuaValue.tableOf();
                            tbl.set("year", (LuaValue)LuaValue.valueOf(d2.get(1)));
                            tbl.set("month", (LuaValue)LuaValue.valueOf(d2.get(2) + 1));
                            tbl.set("day", (LuaValue)LuaValue.valueOf(d2.get(5)));
                            tbl.set("hour", (LuaValue)LuaValue.valueOf(d2.get(11)));
                            tbl.set("min", (LuaValue)LuaValue.valueOf(d2.get(12)));
                            tbl.set("sec", (LuaValue)LuaValue.valueOf(d2.get(13)));
                            tbl.set("wday", (LuaValue)LuaValue.valueOf(d2.get(7)));
                            tbl.set("yday", (LuaValue)LuaValue.valueOf(d2.get(6)));
                            tbl.set("isdst", (LuaValue)LuaValue.valueOf(OsLib.this.isDaylightSavingsTime(d2)));
                            return tbl;
                        }
                        return OsLibFunc.valueOf(OsLib.this.date(s, t == -1.0 ? OsLib.this.time(null) : t));
                    }
                    case 2: {
                        return OsLibFunc.valueOf(OsLib.this.difftime(args.checkdouble(1), args.checkdouble(2)));
                    }
                    case 3: {
                        return OsLib.this.execute(args.optjstring(1, null));
                    }
                    case 4: {
                        OsLib.this.exit(args.optint(1, 0));
                        return NONE;
                    }
                    case 5: {
                        String val = OsLib.this.getenv(args.checkjstring(1));
                        return val != null ? OsLibFunc.valueOf(val) : NIL;
                    }
                    case 6: {
                        OsLib.this.remove(args.checkjstring(1));
                        return LuaValue.TRUE;
                    }
                    case 7: {
                        OsLib.this.rename(args.checkjstring(1), args.checkjstring(2));
                        return LuaValue.TRUE;
                    }
                    case 8: {
                        String s = OsLib.this.setlocale(args.optjstring(1, null), args.optjstring(2, "all"));
                        return s != null ? OsLibFunc.valueOf(s) : NIL;
                    }
                    case 9: {
                        return OsLibFunc.valueOf(OsLib.this.time(args.opttable(1, null)));
                    }
                    case 10: {
                        return OsLibFunc.valueOf(OsLib.this.tmpname());
                    }
                }
                return NONE;
            }
            catch (IOException e) {
                return OsLibFunc.varargsOf(NIL, (Varargs)OsLibFunc.valueOf(e.getMessage()));
            }
        }
    }
}

