/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2.compiler;

import org.mod.luaj.vm2.LocVars;
import org.mod.luaj.vm2.Lua;
import org.mod.luaj.vm2.LuaError;
import org.mod.luaj.vm2.LuaString;
import org.mod.luaj.vm2.LuaValue;
import org.mod.luaj.vm2.Prototype;
import org.mod.luaj.vm2.Upvaldesc;
import org.mod.luaj.vm2.compiler.InstructionPtr;
import org.mod.luaj.vm2.compiler.LexState;

public class Constants
extends Lua {
    public static final int MAXSTACK = 250;
    static final int LUAI_MAXUPVAL = 255;
    static final int LUAI_MAXVARS = 200;
    static final int NO_REG = 255;
    static final int iABC = 0;
    static final int iABx = 1;
    static final int iAsBx = 2;
    static final int OpArgN = 0;
    static final int OpArgU = 1;
    static final int OpArgR = 2;
    static final int OpArgK = 3;

    protected static void _assert(boolean b) {
        if (!b) {
            throw new LuaError("compiler assert failed");
        }
    }

    static void SET_OPCODE(InstructionPtr i, int o) {
        i.set(i.get() & 0xFFFFFFC0 | o << 0 & 0x3F);
    }

    static void SETARG_A(int[] code, int index, int u) {
        code[index] = code[index] & 0xFFFFC03F | u << 6 & 0x3FC0;
    }

    static void SETARG_A(InstructionPtr i, int u) {
        i.set(i.get() & 0xFFFFC03F | u << 6 & 0x3FC0);
    }

    static void SETARG_B(InstructionPtr i, int u) {
        i.set(i.get() & 0x7FFFFF | u << 23 & 0xFF800000);
    }

    static void SETARG_C(InstructionPtr i, int u) {
        i.set(i.get() & 0xFF803FFF | u << 14 & 0x7FC000);
    }

    static void SETARG_Bx(InstructionPtr i, int u) {
        i.set(i.get() & 0x3FFF | u << 14 & 0xFFFFC000);
    }

    static void SETARG_sBx(InstructionPtr i, int u) {
        Constants.SETARG_Bx(i, u + 131071);
    }

    static int CREATE_ABC(int o, int a, int b, int c) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | b << 23 & 0xFF800000 | c << 14 & 0x7FC000;
    }

    static int CREATE_ABx(int o, int a, int bc) {
        return o << 0 & 0x3F | a << 6 & 0x3FC0 | bc << 14 & 0xFFFFC000;
    }

    static LuaValue[] realloc(LuaValue[] v, int n) {
        LuaValue[] a = new LuaValue[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static Prototype[] realloc(Prototype[] v, int n) {
        Prototype[] a = new Prototype[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static LuaString[] realloc(LuaString[] v, int n) {
        LuaString[] a = new LuaString[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static LocVars[] realloc(LocVars[] v, int n) {
        LocVars[] a = new LocVars[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static Upvaldesc[] realloc(Upvaldesc[] v, int n) {
        Upvaldesc[] a = new Upvaldesc[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static LexState.Vardesc[] realloc(LexState.Vardesc[] v, int n) {
        LexState.Vardesc[] a = new LexState.Vardesc[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static LexState.Labeldesc[] grow(LexState.Labeldesc[] v, int min_n) {
        return v == null ? new LexState.Labeldesc[2] : (v.length < min_n ? Constants.realloc(v, v.length * 2) : v);
    }

    static LexState.Labeldesc[] realloc(LexState.Labeldesc[] v, int n) {
        LexState.Labeldesc[] a = new LexState.Labeldesc[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static int[] realloc(int[] v, int n) {
        int[] a = new int[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static byte[] realloc(byte[] v, int n) {
        byte[] a = new byte[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    static char[] realloc(char[] v, int n) {
        char[] a = new char[n];
        if (v != null) {
            System.arraycopy(v, 0, a, 0, Math.min(v.length, n));
        }
        return a;
    }

    protected Constants() {
    }
}

