/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class DualSignalReceiver
extends SignalReceiver {
    private SignalAspect topAspect = SignalAspect.BLINK_RED;
    private SignalAspect bottomAspect = SignalAspect.BLINK_RED;

    public DualSignalReceiver(String locTag, TileEntity tile) {
        super(locTag, tile, 2);
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        WorldCoordinate coord = (WorldCoordinate)this.pairings.peekFirst();
        if (coord == null) {
            return;
        }
        if (coord.equals(con.getCoords())) {
            if (aspect != this.topAspect) {
                this.topAspect = aspect;
                super.onControllerAspectChange(con, aspect);
            }
        } else if (aspect != this.bottomAspect) {
            this.bottomAspect = aspect;
            super.onControllerAspectChange(con, aspect);
        }
    }

    @Override
    protected void saveNBT(NBTTagCompound data) {
        super.saveNBT(data);
        data.func_74774_a("topAspect", (byte)this.topAspect.ordinal());
        data.func_74774_a("bottomAspect", (byte)this.bottomAspect.ordinal());
    }

    @Override
    protected void loadNBT(NBTTagCompound data) {
        super.loadNBT(data);
        this.topAspect = SignalAspect.values()[data.func_74771_c("topAspect")];
        this.bottomAspect = SignalAspect.values()[data.func_74771_c("bottomAspect")];
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        data.writeByte(this.topAspect.ordinal());
        data.writeByte(this.bottomAspect.ordinal());
    }

    public void readPacketData(DataInputStream data) throws IOException {
        this.topAspect = SignalAspect.values()[data.readByte()];
        this.bottomAspect = SignalAspect.values()[data.readByte()];
    }

    public SignalAspect getTopAspect() {
        return this.topAspect;
    }

    public SignalAspect getBottomAspect() {
        return this.bottomAspect;
    }

    public boolean setTopAspect(SignalAspect aspect) {
        if (this.topAspect != aspect) {
            this.topAspect = aspect;
            return true;
        }
        return false;
    }

    public boolean setBottomAspect(SignalAspect aspect) {
        if (this.bottomAspect != aspect) {
            this.bottomAspect = aspect;
            return true;
        }
        return false;
    }
}

