/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.electricity;

import java.util.Random;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.api.tracks.RailTools;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public interface IElectricMinecart {
    public ChargeHandler getChargeHandler();

    public static final class ChargeHandler {
        public static final int DRAW_INTERVAL = 8;
        private static final Random rand = new Random();
        private final EntityMinecart minecart;
        private final Type type;
        private double capacity;
        private double charge;
        private double draw;
        private double lastTickDraw;
        private final double lossPerTick;
        private int clock = rand.nextInt();
        private int drewFromTrack;

        public ChargeHandler(EntityMinecart minecart, Type type2, double capactiy) {
            this(minecart, type2, capactiy, 0.0);
        }

        public ChargeHandler(EntityMinecart minecart, Type type2, double capacity, double lossPerTick) {
            this.minecart = minecart;
            this.type = type2;
            this.capacity = capacity;
            this.lossPerTick = lossPerTick;
        }

        public double getCharge() {
            return this.charge;
        }

        public double getCapacity() {
            return this.capacity;
        }

        public double getLosses() {
            return this.lossPerTick;
        }

        public double getDraw() {
            return this.draw;
        }

        public Type getType() {
            return this.type;
        }

        public void balance(ChargeHandler other) {
            double half;
            double total = this.charge + other.charge;
            this.charge = half = total / 2.0;
            other.charge = half;
        }

        public void setCharge(double charge) {
            this.charge = charge;
        }

        public void addCharge(double charge) {
            this.charge += charge;
        }

        public double removeCharge(double request) {
            if (this.charge >= request) {
                this.charge -= request;
                this.lastTickDraw += request;
                return request;
            }
            double ret = this.charge;
            this.charge = 0.0;
            this.lastTickDraw += ret;
            return ret;
        }

        private void removeLosses() {
            if (this.lossPerTick > 0.0) {
                this.charge = this.charge >= this.lossPerTick ? (this.charge -= this.lossPerTick) : 0.0;
            }
        }

        public void tick() {
            ++this.clock;
            this.removeLosses();
            this.draw = (this.draw * 49.0 + this.lastTickDraw) / 50.0;
            this.lastTickDraw = 0.0;
            if (this.drewFromTrack > 0) {
                --this.drewFromTrack;
            } else if (this.type == Type.USER && this.charge < this.capacity / 2.0 && this.clock % 8 == 0) {
                ILinkageManager lm = CartTools.getLinkageManager(this.minecart.field_70170_p);
                for (EntityMinecart cart : lm.getCartsInTrain(this.minecart)) {
                    ChargeHandler ch;
                    if (!(cart instanceof IElectricMinecart) || (ch = ((IElectricMinecart)cart).getChargeHandler()).getType() == Type.USER || !(ch.getCharge() > 0.0)) continue;
                    this.charge += ch.removeCharge(this.capacity - this.charge);
                    break;
                }
            }
        }

        public void tickOnTrack(int trackX, int trackY, int trackZ) {
            IElectricGrid track;
            if (this.type == Type.USER && this.charge < this.capacity && this.clock % 8 == 0 && (track = RailTools.getTrackObjectAt(this.minecart.field_70170_p, trackX, trackY, trackZ, IElectricGrid.class)) != null) {
                double drawnFromTrack = track.getChargeHandler().removeCharge(this.capacity - this.charge);
                if (drawnFromTrack > 0.0) {
                    this.drewFromTrack = 32;
                }
                this.charge += drawnFromTrack;
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("charge", this.charge);
            nbt.func_74782_a("chargeHandler", (NBTBase)tag);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagCompound tag = nbt.func_74775_l("chargeHandler");
            this.charge = tag.func_74769_h("charge");
        }

        public static enum Type {
            USER,
            SOURCE,
            STORAGE;

        }
    }
}

