/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.electricity;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.electricity.GridTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public interface IElectricGrid {
    public static final double MAX_CHARGE = 10000.0;
    public static final double TRACK_LOSS_PER_TICK = 0.05;
    public static final int SEARCH_INTERVAL = 64;
    public static final Random rand = new Random();

    public ChargeHandler getChargeHandler();

    public TileEntity getTile();

    public static final class ChargeHandler {
        private final IElectricGrid gridObject;
        private final ConnectType type;
        private final Set<ChargeHandler> neighbors = new HashSet<ChargeHandler>();
        private double charge;
        private double draw;
        private double lastTickDraw;
        private final double lossPerTick;
        private int clock = rand.nextInt();

        public ChargeHandler(IElectricGrid gridObject, ConnectType type2) {
            this(gridObject, type2, type2 == ConnectType.TRACK ? 0.05 : 0.0);
        }

        public ChargeHandler(IElectricGrid gridObject, ConnectType type2, double lossPerTick) {
            this.gridObject = gridObject;
            this.type = type2;
            this.lossPerTick = lossPerTick;
        }

        public Map<WorldCoordinate, EnumSet<ConnectType>> getPossibleConnectionLocations() {
            return this.type.getPossibleConnectionLocations(this.gridObject);
        }

        public double getCharge() {
            return this.charge;
        }

        public double getCapacity() {
            return 10000.0;
        }

        public double getLosses() {
            return this.lossPerTick;
        }

        public double getDraw() {
            return this.draw;
        }

        public ConnectType getType() {
            return this.type;
        }

        public void balance(ChargeHandler other) {
            double half;
            double total = this.charge + other.charge;
            this.charge = half = total / 2.0;
            other.charge = half;
        }

        public void setCharge(double charge) {
            this.charge = charge;
        }

        public void addCharge(double charge) {
            this.charge += charge;
        }

        public double removeCharge(double request) {
            if (this.charge >= request) {
                this.charge -= request;
                this.lastTickDraw += request;
                return request;
            }
            double ret = this.charge;
            this.charge = 0.0;
            this.lastTickDraw += ret;
            return ret;
        }

        private void removeLosses() {
            if (this.lossPerTick > 0.0) {
                this.charge = this.charge >= this.lossPerTick ? (this.charge -= this.lossPerTick) : 0.0;
            }
        }

        public void tick() {
            ++this.clock;
            this.removeLosses();
            this.draw = (this.draw * 49.0 + this.lastTickDraw) / 50.0;
            this.lastTickDraw = 0.0;
            if (this.charge <= 0.0) {
                return;
            }
            if (this.clock % 64 == 0) {
                this.neighbors.clear();
                Set<IElectricGrid> connections = GridTools.getMutuallyConnectedObjects(this.gridObject);
                for (IElectricGrid iElectricGrid : connections) {
                    this.neighbors.add(iElectricGrid.getChargeHandler());
                }
            }
            Iterator<ChargeHandler> it = this.neighbors.iterator();
            while (it.hasNext()) {
                ChargeHandler ch = it.next();
                if (!ch.gridObject.getTile().func_145837_r()) continue;
                it.remove();
            }
            for (ChargeHandler chargeHandler : this.neighbors) {
                this.balance(chargeHandler);
            }
        }

        public void writeToNBT(NBTTagCompound nbt) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("charge", this.charge);
            nbt.func_74782_a("chargeHandler", (NBTBase)tag);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            NBTTagCompound tag = nbt.func_74775_l("chargeHandler");
            this.charge = tag.func_74769_h("charge");
        }

        public static enum ConnectType {
            TRACK{

                @Override
                public Map<WorldCoordinate, EnumSet<ConnectType>> getPossibleConnectionLocations(IElectricGrid gridObject) {
                    int dim = gridObject.getTile().func_145831_w().field_73011_w.field_76574_g;
                    int x = gridObject.getTile().field_145851_c;
                    int y = gridObject.getTile().field_145848_d;
                    int z = gridObject.getTile().field_145849_e;
                    HashMap<WorldCoordinate, EnumSet<ConnectType>> positions = new HashMap<WorldCoordinate, EnumSet<ConnectType>>();
                    EnumSet<ConnectType> all = EnumSet.allOf(ConnectType.class);
                    EnumSet<ConnectType> notWire = EnumSet.complementOf(EnumSet.of(WIRE));
                    EnumSet<ConnectType> track = EnumSet.of(TRACK);
                    positions.put(new WorldCoordinate(dim, x + 1, y, z), notWire);
                    positions.put(new WorldCoordinate(dim, x - 1, y, z), notWire);
                    positions.put(new WorldCoordinate(dim, x + 1, y + 1, z), track);
                    positions.put(new WorldCoordinate(dim, x + 1, y - 1, z), track);
                    positions.put(new WorldCoordinate(dim, x - 1, y + 1, z), track);
                    positions.put(new WorldCoordinate(dim, x - 1, y - 1, z), track);
                    positions.put(new WorldCoordinate(dim, x, y - 1, z), all);
                    positions.put(new WorldCoordinate(dim, x, y, z + 1), notWire);
                    positions.put(new WorldCoordinate(dim, x, y, z - 1), notWire);
                    positions.put(new WorldCoordinate(dim, x, y + 1, z + 1), track);
                    positions.put(new WorldCoordinate(dim, x, y - 1, z + 1), track);
                    positions.put(new WorldCoordinate(dim, x, y + 1, z - 1), track);
                    positions.put(new WorldCoordinate(dim, x, y - 1, z - 1), track);
                    return positions;
                }
            }
            ,
            WIRE{

                @Override
                public Map<WorldCoordinate, EnumSet<ConnectType>> getPossibleConnectionLocations(IElectricGrid gridObject) {
                    int dim = gridObject.getTile().func_145831_w().field_73011_w.field_76574_g;
                    int x = gridObject.getTile().field_145851_c;
                    int y = gridObject.getTile().field_145848_d;
                    int z = gridObject.getTile().field_145849_e;
                    HashMap<WorldCoordinate, EnumSet<ConnectType>> positions = new HashMap<WorldCoordinate, EnumSet<ConnectType>>();
                    EnumSet<ConnectType> all = EnumSet.allOf(ConnectType.class);
                    EnumSet<ConnectType> notTrack = EnumSet.complementOf(EnumSet.of(TRACK));
                    positions.put(new WorldCoordinate(dim, x + 1, y, z), notTrack);
                    positions.put(new WorldCoordinate(dim, x - 1, y, z), notTrack);
                    positions.put(new WorldCoordinate(dim, x, y + 1, z), all);
                    positions.put(new WorldCoordinate(dim, x, y - 1, z), notTrack);
                    positions.put(new WorldCoordinate(dim, x, y, z + 1), notTrack);
                    positions.put(new WorldCoordinate(dim, x, y, z - 1), notTrack);
                    return positions;
                }
            }
            ,
            BLOCK{

                @Override
                public Map<WorldCoordinate, EnumSet<ConnectType>> getPossibleConnectionLocations(IElectricGrid gridObject) {
                    int dim = gridObject.getTile().func_145831_w().field_73011_w.field_76574_g;
                    int x = gridObject.getTile().field_145851_c;
                    int y = gridObject.getTile().field_145848_d;
                    int z = gridObject.getTile().field_145849_e;
                    HashMap<WorldCoordinate, EnumSet<ConnectType>> positions = new HashMap<WorldCoordinate, EnumSet<ConnectType>>();
                    EnumSet<ConnectType> all = EnumSet.allOf(ConnectType.class);
                    positions.put(new WorldCoordinate(dim, x + 1, y, z), all);
                    positions.put(new WorldCoordinate(dim, x - 1, y, z), all);
                    positions.put(new WorldCoordinate(dim, x, y + 1, z), all);
                    positions.put(new WorldCoordinate(dim, x, y - 1, z), all);
                    positions.put(new WorldCoordinate(dim, x, y, z + 1), all);
                    positions.put(new WorldCoordinate(dim, x, y, z - 1), all);
                    return positions;
                }
            };


            public abstract Map<WorldCoordinate, EnumSet<ConnectType>> getPossibleConnectionLocations(IElectricGrid var1);
        }
    }
}

