/*
 * Decompiled with CFR 0.152.
 */
package emasher.tileentities;

import emasher.blocks.BlockGasGeneric;
import emasher.util.Config;
import emasher.util.Tuple;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TileGas
extends TileEntity {
    public static final int VOLUME = 4000;
    Random rand;
    int count;
    Tuple[] pos = new Tuple[]{new Tuple(0, 1), new Tuple(1, 0), new Tuple(0, -1), new Tuple(-1, 0)};
    private FluidStack gas;

    public TileGas() {
        this.rand = new Random(System.nanoTime());
        this.count = this.rand.nextInt(8);
    }

    public TileGas(Fluid gasType) {
        this.gas = new FluidStack(gasType, 4000);
        this.rand = new Random(System.nanoTime());
        this.count = this.rand.nextInt(8);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockGasGeneric) {
            BlockGasGeneric thisBlock;
            if (this.count == 4) {
                int i;
                thisBlock = (BlockGasGeneric)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                for (i = this.field_145851_c - 1; i < this.field_145851_c + 2; ++i) {
                    for (int j = this.field_145848_d - 1; j < this.field_145848_d + 2; ++j) {
                        for (int k = this.field_145849_e - 1; k < this.field_145849_e + 2; ++k) {
                            if (this.field_145850_b.func_147439_a(i, j, k) != Blocks.field_150480_ab && (this.field_145850_b.func_147439_a(i, j, k) != Blocks.field_150478_aa || this.field_145850_b.field_73013_u != EnumDifficulty.HARD)) continue;
                            thisBlock.contactFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) == emasher.blocks.Blocks.plasma()) {
                    for (i = 0; i < 6; ++i) {
                        if (this.gas.amount <= 1) continue;
                        ForgeDirection d = ForgeDirection.getOrientation((int)i);
                        int xo = this.field_145851_c + d.offsetX;
                        int yo = this.field_145848_d + d.offsetY;
                        int zo = this.field_145849_e + d.offsetZ;
                        Block b = this.field_145850_b.func_147439_a(xo, yo, zo);
                        boolean doDamage = false;
                        if (b != Blocks.field_150350_a && b != Blocks.field_150348_b) {
                            ItemStack is = new ItemStack(b, 1, this.field_145850_b.func_72805_g(xo, yo, zo));
                            ItemStack product = FurnaceRecipes.func_77602_a().func_151395_a(is);
                            if (product != null) {
                                if (product.func_77973_b() != null && !(product.func_77973_b() instanceof ItemBlock)) {
                                    product = ItemStack.func_77944_b((ItemStack)product);
                                    EntityItem drop = new EntityItem(this.field_145850_b, (double)xo, (double)yo, (double)zo, product);
                                    if (product.func_77942_o()) {
                                        drop.func_92059_d().func_77982_d((NBTTagCompound)product.func_77978_p().func_74737_b());
                                    }
                                    if (!this.field_145850_b.field_72995_K) {
                                        this.field_145850_b.func_72838_d((Entity)drop);
                                    }
                                    this.fizz(this.field_145850_b, xo, yo, zo);
                                    doDamage = true;
                                    this.field_145850_b.func_147468_f(xo, yo, zo);
                                } else if (product.func_77973_b() != null && product.func_77973_b() instanceof ItemBlock && (b != Blocks.field_150354_m || Config.smeltSand())) {
                                    this.field_145850_b.func_147465_d(xo, yo, zo, Block.func_149634_a((Item)product.func_77973_b()), product.func_77960_j(), 2);
                                    this.fizz(this.field_145850_b, xo, yo, zo);
                                    doDamage = true;
                                }
                            }
                        }
                        if (!doDamage) continue;
                        this.gas.amount /= 2;
                    }
                }
            }
            if (this.count == 8) {
                int x;
                int i;
                int r;
                boolean done;
                thisBlock = (BlockGasGeneric)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (this.gas.amount <= 8) {
                    if (this.canDis(10)) {
                        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                        this.moveToOffset(0, 1, 0);
                    } else if (thisBlock.canDestroyBlock(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e), this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.field_145850_b) && this.gas.amount > 1) {
                        this.gas.amount /= 2;
                        this.moveToOffset(0, 1, 0);
                    } else {
                        done = false;
                        r = this.rand.nextInt(4);
                        for (i = 0; i < 4 && !done; ++i) {
                            int z;
                            x = this.pos[r].x();
                            if (this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + (z = this.pos[r].y()))) {
                                this.moveToOffset(x, 0, z);
                                done = true;
                            } else if (thisBlock.canDestroyBlock(this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z), this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z, this.field_145850_b) && this.gas.amount > 1) {
                                this.gas.amount /= 2;
                                this.moveToOffset(x, 0, z);
                            }
                            if (++r != 4) continue;
                            r = 0;
                        }
                    }
                } else if (this.gas.amount > 8) {
                    if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                        this.splitToOffset(0, 1, 0);
                    } else if (thisBlock.canDestroyBlock(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e), this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.field_145850_b)) {
                        this.gas.amount /= 2;
                        this.splitToOffset(0, 1, 0);
                    } else {
                        done = false;
                        r = this.rand.nextInt(4);
                        for (i = 0; i < 4 && !done; ++i) {
                            int z;
                            x = this.pos[r].x();
                            if (this.field_145850_b.func_147437_c(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + (z = this.pos[r].y()))) {
                                this.splitToOffset(x, 0, z);
                                done = true;
                            } else if (thisBlock.canDestroyBlock(this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z), this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z, this.field_145850_b)) {
                                this.gas.amount /= 2;
                                this.splitToOffset(x, 0, z);
                                done = true;
                            }
                            if (++r != 4) continue;
                            r = 0;
                        }
                        if (!done && this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) {
                            this.splitToOffset(0, -1, 0);
                        }
                    }
                }
                this.count = 0;
            } else {
                ++this.count;
            }
        }
    }

    public boolean canDis(int n) {
        boolean result = true;
        for (int i = 0; result && i < n; ++i) {
            result = this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + i + 1, this.field_145849_e);
        }
        return result;
    }

    public void moveToOffset(int x, int y, int z) {
        this.field_145850_b.func_147465_d(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, this.gas.getFluid().getBlock(), this.field_145847_g, 4);
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
        if (t != null && t instanceof TileGas) {
            ((TileGas)t).setGasAmount(this.gas.amount);
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void splitToOffset(int x, int y, int z) {
        int meta;
        int vol;
        this.field_145850_b.func_147449_b(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, this.gas.getFluid().getBlock());
        TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
        if (t != null && t instanceof TileGas) {
            TileGas tg = (TileGas)t;
            tg.setGasAmount(this.gas.amount / 2);
            vol = tg.getGasAmount();
            meta = vol * 15 / 4000;
            this.field_145850_b.func_72921_c(x + this.field_145851_c, y + this.field_145848_d, z + this.field_145849_e, meta, 4);
        }
        this.gas.amount /= 2;
        vol = this.gas.amount;
        meta = vol * 15 / 4000;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 4);
    }

    public int getGasAmount() {
        return this.gas.amount;
    }

    public void setGasAmount(int newAmount) {
        this.gas.amount = newAmount;
    }

    public int getExplosionSize() {
        return 4;
    }

    public void setGasAmount(int newAmount, World world, int x, int y, int z) {
        this.gas.amount = newAmount;
        world.func_72921_c(x, y, z, TileGas.entityToBlock(newAmount), 2);
    }

    public FluidStack getGas() {
        return this.gas;
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("Amount")) {
            this.gas = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data);
        }
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.gas.writeToNBT(data);
    }

    public void fizz(World world, int x, int y, int z) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f);
        for (int i = 0; i < 10; ++i) {
            world.func_72869_a("smoke", (double)x + this.field_145850_b.field_73012_v.nextDouble() - 0.5, (double)y + this.field_145850_b.field_73012_v.nextDouble() - 0.5, (double)z + this.field_145850_b.field_73012_v.nextDouble() - 0.5, 0.0, 0.0, 0.0);
        }
    }

    public static int entityToBlock(int entAmount) {
        return entAmount * 15 / 4000;
    }
}

