/*
 * Decompiled with CFR 0.152.
 */
package emasher.packethandling;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import emasher.packethandling.AdapterSideMessage;
import emasher.packethandling.ChangerSideMessage;
import emasher.packethandling.NetworkUtilities;
import emasher.packethandling.PipeColourMessage;
import emasher.packethandling.SocketFluidMessage;
import emasher.packethandling.SocketItemMessage;
import emasher.packethandling.SocketStateMessage;
import emasher.tileentities.TileAdapterBase;
import emasher.tileentities.TileDirectionChanger;
import emasher.tileentities.TilePipeBase;
import emasher.tileentities.TileSocket;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class RequestInfoFromServerMessage
implements IMessage {
    byte[] msg;
    TileEntity te;
    byte tag;
    byte id;

    public RequestInfoFromServerMessage() {
    }

    public RequestInfoFromServerMessage(TileEntity te, byte tag, byte id) {
        this.te = te;
        this.tag = tag;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.msg = new byte[buf.capacity()];
        buf.readBytes(this.msg);
    }

    public void toBytes(ByteBuf buf) {
        byte[] out = new byte[18];
        out[0] = this.id;
        NetworkUtilities.toByte(out, this.te.field_145851_c, 1);
        NetworkUtilities.toByte(out, this.te.field_145848_d, 5);
        NetworkUtilities.toByte(out, this.te.field_145849_e, 9);
        NetworkUtilities.toByte(out, this.te.func_145831_w().field_73011_w.field_76574_g, 13);
        out[17] = this.tag;
        buf.capacity(18);
        buf.writeBytes(out);
        this.msg = out;
    }

    public static class Handler
    implements IMessageHandler<RequestInfoFromServerMessage, IMessage> {
        public IMessage onMessage(RequestInfoFromServerMessage message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            byte id = message.msg[0];
            int x = NetworkUtilities.toInteger(message.msg, 1);
            int y = NetworkUtilities.toInteger(message.msg, 5);
            int z = NetworkUtilities.toInteger(message.msg, 9);
            TileEntity te = world.func_147438_o(x, y, z);
            int dimID = NetworkUtilities.toInteger(message.msg, 13);
            byte tag = message.msg[17];
            switch (id) {
                case 0: {
                    if (te == null || !(te instanceof TileSocket)) break;
                    TileSocket ts = (TileSocket)te;
                    return new SocketStateMessage(ts, tag);
                }
                case 1: {
                    if (te == null || !(te instanceof TileSocket)) break;
                    TileSocket ts = (TileSocket)te;
                    return new SocketItemMessage(ts, tag);
                }
                case 2: {
                    if (te == null || !(te instanceof TileSocket)) break;
                    TileSocket ts = (TileSocket)te;
                    return new SocketFluidMessage(ts, tag);
                }
                case 3: {
                    if (te == null || !(te instanceof TilePipeBase)) break;
                    TilePipeBase ts = (TilePipeBase)te;
                    return new PipeColourMessage(ts);
                }
                case 4: {
                    if (te == null || !(te instanceof TileAdapterBase)) break;
                    TileAdapterBase ts = (TileAdapterBase)te;
                    return new AdapterSideMessage(ts, tag);
                }
                case 5: {
                    if (te == null || !(te instanceof TileDirectionChanger)) break;
                    TileDirectionChanger ts = (TileDirectionChanger)te;
                    return new ChangerSideMessage(ts, tag);
                }
            }
            return null;
        }
    }
}

