/*
 * Decompiled with CFR 0.152.
 */
package emasher.packethandling;

import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import emasher.api.SideConfig;
import emasher.blocks.Blocks;
import emasher.packethandling.AdapterSideMessage;
import emasher.packethandling.ChangerSideMessage;
import emasher.packethandling.NetworkUtilities;
import emasher.packethandling.PipeColourMessage;
import emasher.packethandling.SocketFluidMessage;
import emasher.packethandling.SocketItemMessage;
import emasher.packethandling.SocketStateMessage;
import emasher.tileentities.TileAdapterBase;
import emasher.tileentities.TileDirectionChanger;
import emasher.tileentities.TilePipeBase;
import emasher.tileentities.TileSocket;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Handlers {
    public static void onSocketStateMessage(SocketStateMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = NetworkUtilities.toInteger(message.msg, 10);
        int y = NetworkUtilities.toInteger(message.msg, 14);
        int z = NetworkUtilities.toInteger(message.msg, 18);
        byte side = message.msg[1];
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileSocket) {
            TileSocket ts = (TileSocket)te;
            SideConfig c = ts.configs[side];
            c.meta = NetworkUtilities.toInteger(message.msg, 6);
            ts.sides[side] = NetworkUtilities.toInteger(message.msg, 22);
            c.tank = message.msg[2];
            c.inventory = message.msg[3];
            c.rsControl[0] = (message.msg[4] & 1) != 0;
            c.rsControl[1] = (message.msg[4] & 2) != 0;
            c.rsControl[2] = (message.msg[4] & 4) != 0;
            c.rsLatch[0] = (message.msg[5] & 1) != 0;
            c.rsLatch[1] = (message.msg[5] & 2) != 0;
            c.rsLatch[2] = (message.msg[5] & 4) != 0;
            ts.sides[side] = NetworkUtilities.toInteger(message.msg, 22);
            ts.sideLocked[side] = NetworkUtilities.byteToBool(message.msg[26]);
            ts.facID[side] = NetworkUtilities.toInteger(message.msg, 27);
            ts.facMeta[side] = NetworkUtilities.toInteger(message.msg, 31);
            world.func_147471_g(x, y, z);
            world.func_147444_c(x, y, z, (Block)Blocks.socket());
        }
    }

    public static void onSocketItemMessage(SocketItemMessage message, MessageContext ctx) {
        TileEntity te;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = NetworkUtilities.toInteger(message.msg, 9);
        int y = NetworkUtilities.toInteger(message.msg, 13);
        int z = NetworkUtilities.toInteger(message.msg, 17);
        int id = NetworkUtilities.toInteger(message.msg, 1);
        int damage = NetworkUtilities.toInteger(message.msg, 5);
        byte inventory = message.msg[22];
        int size = NetworkUtilities.toInteger(message.msg, 23);
        ItemStack s = null;
        if (id != -1) {
            s = new ItemStack(Item.func_150899_d((int)id), size, damage);
            if (message.msg.length > 27) {
                NBTTagCompound NBTData = null;
                byte[] NBTArray = new byte[message.msg.length - 27];
                for (int i = 0; i < message.msg.length - 27; ++i) {
                    NBTArray[i] = message.msg[i + 27];
                }
                try {
                    NBTData = CompressedStreamTools.func_152457_a((byte[])NBTArray, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
                    if (NBTData != null) {
                        s.func_77982_d(NBTData);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if ((te = world.func_147438_o(x, y, z)) != null && te instanceof TileSocket) {
            TileSocket ts = (TileSocket)te;
            if (id != -1) {
                ts.inventory.func_70299_a((int)inventory, new ItemStack(Item.func_150899_d((int)id), size, damage));
            } else {
                ts.inventory.func_70299_a((int)inventory, null);
            }
            world.func_147471_g(x, y, z);
            world.func_147444_c(x, y, z, (Block)Blocks.socket());
        }
    }

    public static void onSocketFluidMessage(SocketFluidMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = NetworkUtilities.toInteger(message.msg, 1);
        int y = NetworkUtilities.toInteger(message.msg, 5);
        int z = NetworkUtilities.toInteger(message.msg, 9);
        int id = NetworkUtilities.toInteger(message.msg, 13);
        int meta = NetworkUtilities.toInteger(message.msg, 17);
        int amnt = NetworkUtilities.toInteger(message.msg, 22);
        byte tank = message.msg[26];
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileSocket) {
            TileSocket ts = (TileSocket)te;
            if (tank > -1 && tank < 3) {
                if (id != -1) {
                    ts.tanks[tank].setFluid(new FluidStack(FluidRegistry.getFluid((int)id), amnt));
                } else {
                    ts.tanks[tank].setFluid(null);
                }
            }
            world.func_147471_g(x, y, z);
            world.func_147444_c(x, y, z, (Block)Blocks.socket());
        }
    }

    public static void onPipeColourMessage(PipeColourMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = NetworkUtilities.toInteger(message.msg, 1);
        int y = NetworkUtilities.toInteger(message.msg, 5);
        int z = NetworkUtilities.toInteger(message.msg, 9);
        int id = NetworkUtilities.toInteger(message.msg, 13);
        int colour = message.msg[17];
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TilePipeBase) {
            TilePipeBase p = (TilePipeBase)te;
            p.colour = colour;
            world.func_147471_g(x, y, z);
            world.func_147444_c(x, y, z, world.func_147439_a(x, y, z));
        }
    }

    public static void onAdapterSideMessage(AdapterSideMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = NetworkUtilities.toInteger(message.msg, 1);
        int y = NetworkUtilities.toInteger(message.msg, 5);
        int z = NetworkUtilities.toInteger(message.msg, 9);
        int id = NetworkUtilities.toInteger(message.msg, 13);
        boolean output = false;
        if (message.msg[17] != 0) {
            output = true;
        }
        byte side = message.msg[18];
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileAdapterBase) {
            TileAdapterBase t = (TileAdapterBase)te;
            t.outputs[side] = output;
            world.func_147471_g(x, y, z);
            world.func_147444_c(x, y, z, world.func_147439_a(x, y, z));
        }
    }

    public static void onChangeSideMessage(ChangerSideMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        int x = NetworkUtilities.toInteger(message.msg, 1);
        int y = NetworkUtilities.toInteger(message.msg, 5);
        int z = NetworkUtilities.toInteger(message.msg, 9);
        int id = NetworkUtilities.toInteger(message.msg, 13);
        ForgeDirection dir = ForgeDirection.getOrientation((int)message.msg[17]);
        byte side = message.msg[18];
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileDirectionChanger) {
            TileDirectionChanger t = (TileDirectionChanger)te;
            t.directions[side] = dir;
            world.func_147471_g(x, y, z);
            world.func_147444_c(x, y, z, world.func_147439_a(x, y, z));
        }
    }
}

