/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class ModStateCell
extends SocketModule {
    public static final int[] settings = new int[]{10, 20, 40, 80, 160, 200, 600, 1200};

    public ModStateCell(int id) {
        super(id, "eng_toolbox:stateCell");
    }

    @Override
    public String getLocalizedName() {
        return "State Cell";
    }

    public void getToolTip(List l) {
        l.add("Creates a sustained external redstone pulse");
        l.add("after recieving an internal one for a");
        l.add("configured amount of time");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_RED() + "RS control channel");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
        l.add(Config.PREF_WHITE() + "Modify length of delay");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"rtr", " b ", Character.valueOf('t'), Items.field_151113_aN, Character.valueOf('r'), Blocks.field_150429_aA, Character.valueOf('b'), new ItemStack(emasher.items.Items.module(), 1, 17)});
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isRedstoneInterface() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        int timer = config.meta >> 6;
        if (timer == 0) {
            return "eng_toolbox:inner_redstone_inactive";
        }
        return "eng_toolbox:inner_redstone_active";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_redstone_inactive", "eng_toolbox:inner_redstone_active"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon[] getAdditionalOverlays(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        int setting = 0;
        int time = 0;
        int on = 0;
        setting = config.meta >> 3;
        on = config.meta & 7;
        time = config.meta >> 6;
        time = (int)Math.ceil(time * 7 / settings[setting &= 7]);
        if (config.meta >> 6 != 0) {
            return new IIcon[]{emasher.blocks.Blocks.socket().bar1[setting], emasher.blocks.Blocks.socket().bar2[time]};
        }
        return new IIcon[]{emasher.blocks.Blocks.socket().bar1[setting]};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean flipBottomOverlay() {
        return true;
    }

    @Override
    public boolean isOutputtingRedstone(SideConfig config, SocketTileAccess ts) {
        return config.tank == 1;
    }

    @Override
    public void onRSInterfaceChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (config.tank != 1 && on) {
            config.tank = 1;
            ts.updateAdj(side);
            ts.sendClientSideState(side.ordinal());
        }
    }

    @Override
    public void onRSLatchChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (config.tank != 1 && on) {
            config.tank = 1;
            ts.updateAdj(side);
            ts.sendClientSideState(side.ordinal());
        }
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        int setting = 0;
        int oldTime = 0;
        int reBuild = 0;
        int on = config.meta & 7;
        boolean reRender = false;
        boolean updateAdj = false;
        setting = config.meta >> 3;
        setting &= 7;
        int time = oldTime = config.meta >> 6;
        if (config.tank == 1) {
            int timeDisp;
            if ((oldTime = (int)Math.ceil(oldTime * 7 / settings[setting])) != (timeDisp = (int)Math.ceil(++time * 7 / settings[setting]))) {
                reRender = true;
            }
            if (time >= settings[setting]) {
                time = 0;
                on = 1;
                reRender = true;
                updateAdj = true;
                config.tank = 0;
            }
        }
        reBuild = time;
        reBuild <<= 3;
        reBuild |= setting;
        reBuild <<= 3;
        config.meta = reBuild |= on;
        if (reRender) {
            ts.sendClientSideState(side.ordinal());
        }
        if (updateAdj) {
            ts.updateAdj(side);
        }
    }

    @Override
    public void onGenericRemoteSignal(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        int on = config.meta & 7;
        int setting = config.meta >> 3;
        setting &= 7;
        int time = config.meta >> 6;
        int reBuild = 0;
        if (++setting >= 8) {
            setting = 0;
        }
        reBuild = 0;
        reBuild <<= 3;
        reBuild |= setting;
        reBuild <<= 3;
        config.meta = reBuild |= on;
        ts.sendClientSideState(side.ordinal());
    }
}

