/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ModLatchReset
extends SocketModule {
    public ModLatchReset(int id) {
        super(id, "eng_toolbox:RESET_0");
    }

    @Override
    public String getLocalizedName() {
        return "Redstone Latch Reset";
    }

    public void getToolTip(List l) {
        l.add("Tuns off selected internal RS latches");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_DARK_PURPLE() + "RS latches to turn off");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"tgr", " b ", Character.valueOf('t'), Blocks.field_150429_aA, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('g'), Items.field_151042_j, Character.valueOf('b'), new ItemStack(emasher.items.Items.module(), 1, 16)});
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInternalTexture(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.meta == 0) {
            return "eng_toolbox:inner_redstone_inactive";
        }
        return "eng_toolbox:inner_redstone_active";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String[] getAllInternalTextures() {
        return new String[]{"eng_toolbox:inner_redstone_inactive", "eng_toolbox:inner_redstone_active"};
    }

    @Override
    public boolean isRedstoneInterface() {
        return true;
    }

    @Override
    public void updateRestone(boolean on, SideConfig config, SocketTileAccess ts) {
        for (int i = 0; i < 3; ++i) {
            if (!config.rsLatch[i]) continue;
            if (on) {
                ts.modifyLatch(i, false);
                config.meta = 1;
                continue;
            }
            config.meta = 0;
        }
    }
}

