/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModKiln
extends SocketModule {
    public ModKiln(int id) {
        super(id, "eng_toolbox:kiln");
    }

    @Override
    public String getLocalizedName() {
        return "Kiln";
    }

    public void getToolTip(List l) {
        l.add("Turns Ground Limestone into Quicklime");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_AQUA() + "Requires 100 RF/t");
        l.add("The multi-block structure is 3x7x3");
        l.add("See wiki for further instructions...");
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"nln", "rrr", "pbp", Character.valueOf('n'), "ingotNickel", Character.valueOf('l'), "blockNickel", Character.valueOf('r'), Items.field_151072_bj, Character.valueOf('p'), emasher.items.Items.psu(), Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        return side != ForgeDirection.UP && side != ForgeDirection.DOWN;
    }

    @Override
    public void init(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        config.meta = 0;
        ts.sideInventory.func_70299_a(side.ordinal(), new ItemStack(Blocks.field_150348_b, 1, 0));
    }

    @Override
    public void onRemoved(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        ts.sideInventory.func_70299_a(side.ordinal(), null);
        int xo = ts.field_145851_c + side.offsetX;
        int yo = ts.field_145848_d;
        int zo = ts.field_145849_e + side.offsetZ;
        if (ts.func_145831_w().func_147439_a(xo, yo, zo) == emasher.blocks.Blocks.groundLimestone()) {
            ts.func_145831_w().func_72921_c(xo, yo, zo, 0, 3);
        }
        this.setMeta(ts.func_145831_w(), ts, side, 2);
    }

    @Override
    public void onSocketRemoved(SideConfig config, SocketTileAccess ts, ForgeDirection side, boolean wrenched) {
        super.onSocketRemoved(config, ts, side, wrenched);
        if (wrenched) {
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d;
            int zo = ts.field_145849_e + side.offsetZ;
            if (ts.func_145831_w().func_147439_a(xo, yo, zo) == emasher.blocks.Blocks.groundLimestone()) {
                ts.func_145831_w().func_72921_c(xo, yo, zo, 0, 3);
            }
            this.setMeta(ts.func_145831_w(), ts, side, 2);
            ItemStack stack = ts.sideInventory.func_70301_a(side.ordinal());
            if (stack != null) {
                stack.func_77964_b(0);
            }
        }
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        ++config.meta;
        if (config.meta % 10 == 0 && this.isValidKiln(ts, side)) {
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d;
            int zo = ts.field_145849_e + side.offsetZ;
            if (ts.func_145831_w().func_147439_a(xo, yo, zo) == emasher.blocks.Blocks.groundLimestone()) {
                if (ts.getEnergyStored() >= 1000) {
                    ItemStack stack = ts.sideInventory.func_70301_a(side.ordinal());
                    ts.func_145831_w().func_72921_c(xo, yo, zo, 1, 3);
                    if (stack.field_77994_a >= 32) {
                        ts.func_145831_w().func_147468_f(xo, yo, zo);
                        this.dropItemsOnSide(ts, side, xo, yo, zo, new ItemStack(emasher.items.Items.dusts(), ts.func_145831_w().field_73012_v.nextInt(3) + 1, 0));
                        stack.field_77994_a = 1;
                    } else {
                        ++stack.field_77994_a;
                    }
                    ts.useEnergy(1000, false);
                } else {
                    ts.func_145831_w().func_72921_c(xo, yo, zo, 0, 3);
                }
            }
        }
        if (config.meta >= 400) {
            config.meta = 0;
            int y = ts.field_145848_d + 4;
            if (this.checkMultiBlock(config, ts, side)) {
                this.setMeta(ts.func_145831_w(), ts, side, 5);
                ItemStack stack = ts.sideInventory.func_70301_a(side.ordinal());
                stack.func_77964_b(1);
            } else {
                this.setMeta(ts.func_145831_w(), ts, side, 2);
                ItemStack stack = ts.sideInventory.func_70301_a(side.ordinal());
                stack.func_77964_b(0);
            }
        }
    }

    private boolean checkMultiBlock(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (side == ForgeDirection.DOWN || side == ForgeDirection.UP) {
            return false;
        }
        int y = ts.field_145848_d;
        int x = ts.field_145851_c;
        int z = ts.field_145849_e;
        World w = ts.func_145831_w();
        if (!this.checkLayer(config, ts, side, y - 1)) {
            return false;
        }
        if (side.offsetX == 0) {
            if (!this.checkBlock(w, x - 1, y, z)) {
                return false;
            }
            if (!this.checkBlock(w, x + 1, y, z)) {
                return false;
            }
            if (!this.checkBlock(w, x - 1, y, z + side.offsetZ + side.offsetZ)) {
                return false;
            }
            if (!this.checkBlock(w, x + 1, y, z + side.offsetZ + side.offsetZ)) {
                return false;
            }
        } else {
            if (!this.checkBlock(w, x, y, z - 1)) {
                return false;
            }
            if (!this.checkBlock(w, x, y, z + 1)) {
                return false;
            }
            if (!this.checkBlock(w, x + side.offsetX + side.offsetX, y, z - 1)) {
                return false;
            }
            if (!this.checkBlock(w, x + side.offsetX + side.offsetX, y, z + 1)) {
                return false;
            }
        }
        ++y;
        for (int i = 0; i < 5; ++i) {
            if (this.checkLayer(config, ts, side, y + i)) continue;
            return false;
        }
        return true;
    }

    private boolean checkLayer(SideConfig config, SocketTileAccess ts, ForgeDirection side, int y) {
        int x = ts.field_145851_c;
        int z = ts.field_145849_e;
        World w = ts.func_145831_w();
        if (side.offsetX == 0) {
            int meta;
            int i;
            int zo = z;
            for (i = x - 1; i <= x + 1; ++i) {
                meta = w.func_72805_g(i, y, zo);
                if (w.func_147439_a(i, y, zo) == emasher.blocks.Blocks.normalCube() && (meta == 2 || meta == 5)) continue;
                return false;
            }
            zo = z + side.offsetZ;
            meta = w.func_72805_g(x - 1, y, zo);
            if (w.func_147439_a(x - 1, y, zo) != emasher.blocks.Blocks.normalCube() || meta != 2 && meta != 5) {
                return false;
            }
            meta = w.func_72805_g(x + 1, y, zo);
            if (w.func_147439_a(x + 1, y, zo) != emasher.blocks.Blocks.normalCube() || meta != 2 && meta != 5) {
                return false;
            }
            zo += side.offsetZ;
            for (i = x - 1; i <= x + 1; ++i) {
                meta = w.func_72805_g(i, y, zo);
                if (w.func_147439_a(i, y, zo) == emasher.blocks.Blocks.normalCube() && (meta == 2 || meta == 5)) continue;
                return false;
            }
        } else {
            int meta;
            int i;
            int xo = x;
            for (i = z - 1; i <= z + 1; ++i) {
                meta = w.func_72805_g(xo, y, i);
                if (w.func_147439_a(xo, y, i) == emasher.blocks.Blocks.normalCube() && (meta == 2 || meta == 5)) continue;
                return false;
            }
            xo = x + side.offsetX;
            meta = w.func_72805_g(xo, y, z - 1);
            if (w.func_147439_a(xo, y, z - 1) != emasher.blocks.Blocks.normalCube() || meta != 2 && meta != 5) {
                return false;
            }
            meta = w.func_72805_g(xo, y, z + 1);
            if (w.func_147439_a(xo, y, z + 1) != emasher.blocks.Blocks.normalCube() || meta != 2 && meta != 5) {
                return false;
            }
            xo += side.offsetX;
            for (i = z - 1; i <= z + 1; ++i) {
                meta = w.func_72805_g(xo, y, i);
                if (w.func_147439_a(xo, y, i) == emasher.blocks.Blocks.normalCube() && (meta == 2 || meta == 5)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkBlock(World w, int x, int y, int z) {
        int meta = w.func_72805_g(x, y, z);
        return w.func_147439_a(x, y, z) == emasher.blocks.Blocks.normalCube() && (meta == 2 || meta == 5);
    }

    private void setMeta(World w, SocketTileAccess ts, ForgeDirection side, int newMeta) {
        int x = ts.field_145851_c;
        int z = ts.field_145849_e;
        int y = ts.field_145848_d + 4;
        int oldMeta = newMeta == 2 ? 5 : 2;
        if (side.offsetX == 0) {
            int meta;
            int i;
            int zo = z;
            for (i = x - 1; i <= x + 1; ++i) {
                meta = w.func_72805_g(i, y, zo);
                if (w.func_147439_a(i, y, zo) != emasher.blocks.Blocks.normalCube() || meta != oldMeta) continue;
                w.func_72921_c(i, y, zo, newMeta, 3);
            }
            zo = z + side.offsetZ;
            meta = w.func_72805_g(x - 1, y, zo);
            if (w.func_147439_a(x - 1, y, zo) == emasher.blocks.Blocks.normalCube() && meta == oldMeta) {
                w.func_72921_c(x - 1, y, zo, newMeta, 3);
            }
            meta = w.func_72805_g(x + 1, y, zo);
            if (w.func_147439_a(x + 1, y, zo) == emasher.blocks.Blocks.normalCube() && meta == oldMeta) {
                w.func_72921_c(x + 1, y, zo, newMeta, 3);
            }
            zo += side.offsetZ;
            for (i = x - 1; i <= x + 1; ++i) {
                meta = w.func_72805_g(i, y, zo);
                if (w.func_147439_a(i, y, zo) != emasher.blocks.Blocks.normalCube() || meta != oldMeta) continue;
                w.func_72921_c(i, y, zo, newMeta, 3);
            }
        } else {
            int meta;
            int i;
            int xo = x;
            for (i = z - 1; i <= z + 1; ++i) {
                meta = w.func_72805_g(xo, y, i);
                if (w.func_147439_a(xo, y, i) != emasher.blocks.Blocks.normalCube() || meta != oldMeta) continue;
                w.func_72921_c(xo, y, i, newMeta, 3);
            }
            xo = x + side.offsetX;
            meta = w.func_72805_g(xo, y, z - 1);
            if (w.func_147439_a(xo, y, z - 1) == emasher.blocks.Blocks.normalCube() && meta == oldMeta) {
                w.func_72921_c(xo, y, z - 1, newMeta, 3);
            }
            meta = w.func_72805_g(xo, y, z + 1);
            if (w.func_147439_a(xo, y, z + 1) == emasher.blocks.Blocks.normalCube() && meta == oldMeta) {
                w.func_72921_c(xo, y, z + 1, newMeta, 3);
            }
            xo += side.offsetX;
            for (i = z - 1; i <= z + 1; ++i) {
                meta = w.func_72805_g(xo, y, i);
                if (w.func_147439_a(xo, y, i) != emasher.blocks.Blocks.normalCube() || meta != oldMeta) continue;
                w.func_72921_c(xo, y, i, newMeta, 3);
            }
        }
    }

    private boolean isValidKiln(SocketTileAccess ts, ForgeDirection side) {
        ItemStack stack = ts.sideInventory.func_70301_a(side.ordinal());
        if (stack == null) {
            return false;
        }
        return stack.func_77960_j() != 0;
    }

    public void dropItemsOnSide(SocketTileAccess ts, ForgeDirection side, int xo, int yo, int zo, ItemStack stack) {
        World worldObj = ts.func_145831_w();
        if (!worldObj.field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(worldObj.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(worldObj, (double)xo + d0, (double)yo + d1, (double)zo + d2, stack);
            entityitem.field_145804_b = 1;
            worldObj.func_72838_d((Entity)entityitem);
        }
    }
}

