/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ModItemOutput
extends SocketModule {
    public ModItemOutput(int id) {
        super(id, "eng_toolbox:itemOutput");
    }

    @Override
    public String getLocalizedName() {
        return "Item Output";
    }

    public void getToolTip(List l) {
        l.add("Outputs items from its configured inventory");
        l.add("to adjacent pipes/inventories/etc.");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Inventory to output from");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"h", "d", "b", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('h'), Blocks.field_150415_aT, Character.valueOf('d'), Blocks.field_150409_cd, Character.valueOf('b'), emasher.items.Items.blankSide()});
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.inventory < 0 || config.inventory > 2) {
            return;
        }
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    if (ts.tryInsertItem(ts.getStackInInventorySlot(config.inventory), side)) {
                        ts.extractItemInternal(true, config.inventory, 1);
                    }
                    return;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                if (ts.tryInsertItem(ts.getStackInInventorySlot(config.inventory), side)) {
                    ts.extractItemInternal(true, config.inventory, 1);
                }
                return;
            }
            allOff = false;
        }
        if (allOff && ts.tryInsertItem(ts.getStackInInventorySlot(config.inventory), side)) {
            ts.extractItemInternal(true, config.inventory, 1);
        }
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public boolean isItemInterface() {
        return true;
    }

    @Override
    public boolean canExtractItems() {
        return true;
    }

    @Override
    public boolean canDirectlyExtractItems(SideConfig config, SocketTileAccess ts) {
        if (config.inventory < 0 || config.inventory > 2) {
            return false;
        }
        boolean allOff = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i]) {
                if (ts.getRSControl(i)) {
                    return true;
                }
                allOff = false;
            }
            if (!config.rsLatch[i]) continue;
            if (ts.getRSLatch(i)) {
                return true;
            }
            allOff = false;
        }
        return allOff;
    }

    @Override
    public ItemStack itemExtract(int amount, boolean doExtract, SideConfig config, SocketTileAccess ts) {
        if (config.inventory != -1) {
            return ts.extractItemInternal(doExtract, config.inventory, amount);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory != -1) {
            return ts.getStackInInventorySlot(config.inventory);
        }
        return null;
    }

    @Override
    public void onInventoryChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (index == config.inventory) {
            ts.sendClientInventorySlot(index);
        }
    }
}

