/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ModItemEjector
extends SocketModule {
    public ModItemEjector(int id) {
        super(id, "eng_toolbox:itemEjector");
    }

    @Override
    public String getLocalizedName() {
        return "Item Ejector";
    }

    public void getToolTip(List l) {
        l.add("Ejects items into the world");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Inventory to pull from");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.module(), 1, this.moduleID), (Object[])new Object[]{"h", "d", "b", Character.valueOf('d'), Blocks.field_150367_z, Character.valueOf('h'), Blocks.field_150415_aT, Character.valueOf('u'), Blocks.field_150415_aT, Character.valueOf('b'), Items.blankSide()});
    }

    @Override
    public void onAdjChange(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        this.onInventoryChange(config, config.inventory, ts, side, true);
    }

    @Override
    public void init(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        this.onInventoryChange(config, config.inventory, ts, side, true);
    }

    @Override
    public void indicatorUpdated(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        this.onInventoryChange(config, config.inventory, ts, side, true);
    }

    @Override
    public void onInventoryChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        if (add) {
            if (config.inventory != index) {
                return;
            }
            if (config.inventory < 0 || config.inventory > 2) {
                return;
            }
            if (ts.getStackInInventorySlot(config.inventory) == null) {
                return;
            }
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d + side.offsetY;
            int zo = ts.field_145849_e + side.offsetZ;
            if (!ts.func_145831_w().func_147437_c(xo, yo, zo)) {
                return;
            }
            boolean allOff = true;
            for (int i = 0; i < 3; ++i) {
                if (config.rsControl[i]) {
                    if (ts.getRSControl(i)) {
                        this.dropItemsOnSide(ts, config, side, xo, yo, zo, ts.getStackInInventorySlot(config.inventory));
                        return;
                    }
                    allOff = false;
                }
                if (!config.rsLatch[i]) continue;
                if (ts.getRSLatch(i)) {
                    this.dropItemsOnSide(ts, config, side, xo, yo, zo, ts.getStackInInventorySlot(config.inventory));
                    return;
                }
                allOff = false;
            }
            if (allOff) {
                this.dropItemsOnSide(ts, config, side, xo, yo, zo, ts.getStackInInventorySlot(config.inventory));
            }
        }
        if (index == config.inventory) {
            ts.sendClientInventorySlot(index);
        }
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    public void dropItemsOnSide(SocketTileAccess ts, SideConfig config, ForgeDirection side, int xo, int yo, int zo, ItemStack stack) {
        if (!ts.func_145831_w().field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(ts.func_145831_w(), (double)xo + d0, (double)yo + d1, (double)zo + d2, stack.func_77946_l());
            entityitem.field_145804_b = 1;
            ts.func_145831_w().func_72838_d((Entity)entityitem);
            ts.extractItemInternal(true, config.inventory, ts.getStackInInventorySlot((int)config.inventory).field_77994_a);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemToRender(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        if (config.inventory != -1) {
            return ts.getStackInInventorySlot(config.inventory);
        }
        return null;
    }
}

