/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.blocks.BlockGasGeneric;
import emasher.util.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModFan
extends SocketModule {
    public ModFan(int id) {
        super(id, "eng_toolbox:fan", "eng_toolbox:fanActive");
    }

    @Override
    public String getLocalizedName() {
        return "Fan";
    }

    public void getToolTip(List l) {
        l.add("Sucks gas into an internal tank");
        l.add("within a 3 block radius");
        l.add("on a sustained internal RS signal");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Tank to input into");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public int getCurrentTexture(SideConfig config) {
        if (config.inventory < 1) {
            return 0;
        }
        return 1;
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ipi", " b ", Character.valueOf('c'), emasher.items.Items.circuit(), Character.valueOf('i'), Items.field_151042_j, Character.valueOf('p'), emasher.items.Items.psu(), Character.valueOf('b'), new ItemStack(emasher.items.Items.module(), 1, 4)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ipi", " b ", Character.valueOf('c'), emasher.items.Items.circuit(), Character.valueOf('i'), "ingotAluminum", Character.valueOf('p'), emasher.items.Items.psu(), Character.valueOf('b'), new ItemStack(emasher.items.Items.module(), 1, 4)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ipi", " b ", Character.valueOf('c'), emasher.items.Items.circuit(), Character.valueOf('i'), "ingotTin", Character.valueOf('p'), emasher.items.Items.psu(), Character.valueOf('b'), new ItemStack(emasher.items.Items.module(), 1, 4)}));
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (config.inventory == 1 && config.tank >= 0 && config.tank < 3) {
            ++config.meta;
            if (config.meta == 20) {
                config.meta = 0;
                int x = ts.field_145851_c + side.offsetX;
                int y = ts.field_145848_d + side.offsetY;
                int z = ts.field_145849_e + side.offsetZ;
                int xMin = x;
                int yMin = y;
                int zMin = z;
                if (side.offsetX == 0) {
                    --xMin;
                    ++x;
                }
                if (side.offsetY == 0) {
                    --yMin;
                    ++y;
                }
                if (side.offsetZ == 0) {
                    --zMin;
                    ++z;
                }
                for (int i = xMin; i < x + 1; ++i) {
                    for (int j = yMin; j < y + 1; ++j) {
                        for (int k = zMin; k < z + 1; ++k) {
                            BlockGasGeneric theBlock;
                            FluidStack avaliable;
                            Block b = ts.func_145831_w().func_147439_a(i, j, k);
                            if (b == null || !(b instanceof BlockGasGeneric) || ts.fillInternal(config.tank, avaliable = (theBlock = (BlockGasGeneric)b).drain(ts.func_145831_w(), i, j, k, false), false) != avaliable.amount) continue;
                            ts.fillInternal(config.tank, theBlock.drain(ts.func_145831_w(), i, j, k, true), true);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void onRSInterfaceChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (on && config.rsControl[index]) {
            config.inventory = 1;
        } else if (!on && config.rsControl[index]) {
            boolean turnOff = true;
            for (int i = 0; i < 3; ++i) {
                if (config.rsControl[i] && ts.getRSControl(i)) {
                    turnOff = false;
                }
                if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
                turnOff = false;
            }
            if (turnOff) {
                config.inventory = 0;
                config.meta = 0;
            }
        }
        ts.sendClientSideState(side.ordinal());
    }

    @Override
    public void onRSLatchChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (on && config.rsLatch[index]) {
            config.inventory = 1;
        } else if (!on && config.rsLatch[index]) {
            boolean turnOff = true;
            for (int i = 0; i < 3; ++i) {
                if (config.rsControl[i] && ts.getRSControl(i)) {
                    turnOff = false;
                }
                if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
                turnOff = false;
            }
            if (turnOff) {
                config.inventory = 0;
                config.meta = 0;
            }
        }
        ts.sendClientSideState(side.ordinal());
    }
}

