/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModBurner
extends SocketModule {
    public ModBurner(int id) {
        super(id, "eng_toolbox:burner");
    }

    @Override
    public String getLocalizedName() {
        return "Burner";
    }

    public void getToolTip(List l) {
        l.add("Creates fire with a sustained");
        l.add("internal redstone signal");
        l.add("Can be used to control Nether portals");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"ini", "ifi", " b ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('f'), Items.field_151033_d, Character.valueOf('n'), Blocks.field_150424_aL, Character.valueOf('b'), emasher.items.Items.blankSide()});
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ini", "ifi", " b ", Character.valueOf('i'), "ingotNickel", Character.valueOf('f'), Items.field_151033_d, Character.valueOf('n'), Blocks.field_150424_aL, Character.valueOf('b'), emasher.items.Items.blankSide()}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(emasher.items.Items.module(), 1, this.moduleID), new Object[]{"ini", "ifi", " b ", Character.valueOf('i'), "ingotSteel", Character.valueOf('f'), Items.field_151033_d, Character.valueOf('n'), Blocks.field_150424_aL, Character.valueOf('b'), emasher.items.Items.blankSide()}));
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public void init(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        this.updateFire(ts, config, side);
    }

    @Override
    public void indicatorUpdated(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        this.updateFire(ts, config, side);
    }

    @Override
    public void onRSInterfaceChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        this.updateFire(ts, config, side);
    }

    @Override
    public void onRSLatchChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        this.updateFire(ts, config, side);
    }

    public void updateFire(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        boolean canBurn = false;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i] && ts.getRSControl(i)) {
                canBurn = true;
            }
            if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
            canBurn = true;
        }
        int xo = ts.field_145851_c + side.offsetX;
        int yo = ts.field_145848_d + side.offsetY;
        int zo = ts.field_145849_e + side.offsetZ;
        Block block = ts.func_145831_w().func_147439_a(xo, yo, zo);
        if (block == Blocks.field_150480_ab && !canBurn) {
            ts.func_145831_w().func_147468_f(xo, yo, zo);
        } else if (ts.func_145831_w().func_147437_c(xo, yo, zo) && canBurn) {
            ts.func_145831_w().func_147449_b(xo, yo, zo, (Block)Blocks.field_150480_ab);
        } else if (block == Blocks.field_150427_aO && !canBurn) {
            ts.func_145831_w().func_147468_f(xo, yo, zo);
        }
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        this.updateFire(ts, config, side);
    }
}

