/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.util.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ModBreaker
extends SocketModule {
    public ModBreaker(int id) {
        super(id, "eng_toolbox:breaker");
    }

    @Override
    public String getLocalizedName() {
        return "Breaker";
    }

    public void getToolTip(List l) {
        l.add("Breaks blocks softer than obsidian");
        l.add("and collects their drops");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_GREEN() + "Output Inventory");
        l.add(Config.PREF_RED() + "RS Activation Pulse");
        l.add(Config.PREF_DARK_PURPLE() + "RS Latch Activation Pulse");
        l.add(Config.PREF_YELLOW() + "Extra output sent to machine output");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(emasher.items.Items.module(), 1, this.moduleID), (Object[])new Object[]{"ipi", "ici", " b ", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('p'), Items.field_151035_b, Character.valueOf('c'), Blocks.field_150367_z, Character.valueOf('b'), emasher.items.Items.blankSide()});
    }

    @Override
    public boolean hasInventoryIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public void onRSInterfaceChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (on) {
            this.tryBreakBlock(true, index, ts, config, side);
        }
    }

    @Override
    public void onRSLatchChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        if (on) {
            this.tryBreakBlock(false, index, ts, config, side);
        }
    }

    public void tryBreakBlock(boolean control, int index, SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        boolean canBreak = false;
        if (control) {
            if (config.rsControl[index]) {
                canBreak = true;
            }
        } else if (config.rsLatch[index]) {
            canBreak = true;
        }
        if (config.inventory < 0 || config.inventory > 2) {
            canBreak = false;
        }
        int xo = ts.field_145851_c + side.offsetX;
        int yo = ts.field_145848_d + side.offsetY;
        int zo = ts.field_145849_e + side.offsetZ;
        Block b = ts.func_145831_w().func_147439_a(xo, yo, zo);
        int blockID = Block.func_149682_b((Block)b);
        if (canBreak && b != null && b.func_149712_f(ts.func_145831_w(), xo, yo, zo) < 50.0f && b.func_149712_f(ts.func_145831_w(), xo, yo, zo) >= 0.0f) {
            ArrayList items = b.getDrops(ts.func_145831_w(), xo, yo, zo, ts.func_145831_w().func_72805_g(xo, yo, zo), 0);
            for (ItemStack item : items) {
                if (ts.addItemInternal(item, false, config.inventory) == item.field_77994_a) {
                    ts.addItemInternal(item, true, config.inventory);
                } else if (ts.forceOutputItem(item, false) == item.field_77994_a) {
                    ts.forceOutputItem(item, true);
                } else {
                    this.dropItemsOnSide(ts, side, item);
                }
                ts.func_145831_w().func_147475_p(xo, yo, zo);
                ts.func_145831_w().func_147468_f(xo, yo, zo);
            }
        }
    }

    public void dropItemsOnSide(SocketTileAccess ts, ForgeDirection side, ItemStack stack) {
        if (!ts.func_145831_w().field_72995_K) {
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d + side.offsetY;
            int zo = ts.field_145849_e + side.offsetZ;
            float f = 0.7f;
            double d0 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(ts.func_145831_w().field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(ts.func_145831_w(), (double)xo + d0, (double)yo + d1, (double)zo + d2, stack.func_77946_l());
            entityitem.field_145804_b = 1;
            ts.func_145831_w().func_72838_d((Entity)entityitem);
        }
    }
}

