/*
 * Decompiled with CFR 0.152.
 */
package emasher.blocks;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emasher.EngineersToolbox;
import emasher.api.ModuleRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.items.ItemEngWrench;
import emasher.packethandling.SocketStateMessage;
import emasher.tileentities.TileSocket;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class BlockSocket
extends BlockContainer {
    public static final String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    @SideOnly(value=Side.CLIENT)
    public IIcon[][] textures;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] tankIndicator;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] inventoryIndicator;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] rsIndicator;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] latchIndicator;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] bar1;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] bar2;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] chargeInd;
    @SideOnly(value=Side.CLIENT)
    public IIcon hasData;
    private boolean wrenched = false;

    public BlockSocket() {
        super(Material.field_151573_f);
        this.func_149647_a(EngineersToolbox.tabBlocks());
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileSocket();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        TileSocket ts;
        TileEntity t = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && t != null && t instanceof TileSocket) {
            ts = (TileSocket)t;
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == emasher.items.Items.remote() && !player.func_70093_af()) {
                switch (player.func_71045_bC().func_77960_j()) {
                    case 0: {
                        if (!ts.getSide(ForgeDirection.getOrientation((int)side)).hasTankIndicator() || ts.sideLocked[side]) break;
                        ts.nextTank(side);
                        break;
                    }
                    case 1: {
                        if (!ts.getSide(ForgeDirection.getOrientation((int)side)).hasInventoryIndicator() || ts.sideLocked[side]) break;
                        ts.nextInventory(side);
                        break;
                    }
                    case 2: {
                        if (!ts.getSide(ForgeDirection.getOrientation((int)side)).hasRSIndicator() || ts.sideLocked[side]) break;
                        ts.nextRS(side);
                        break;
                    }
                    case 3: {
                        if (!ts.getSide(ForgeDirection.getOrientation((int)side)).hasLatchIndicator() || ts.sideLocked[side]) break;
                        ts.nextLatch(side);
                        break;
                    }
                    case 4: {
                        if (ts.sideLocked[side]) break;
                        ts.getSide(ForgeDirection.getOrientation((int)side)).onGenericRemoteSignal(ts, ts.configs[side], ForgeDirection.getOrientation((int)side), subX, subY, subZ);
                        break;
                    }
                    case 5: {
                        ts.lockSide(side);
                        break;
                    }
                    case 6: {
                        ts.facID[side] = 0;
                        ts.facMeta[side] = 0;
                        EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(ts, (byte)side), ts.func_145831_w().field_73011_w.field_76574_g);
                    }
                }
            } else if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IToolWrench) {
                EntityItem entityitem;
                if (player.func_71045_bC().func_77973_b() instanceof ItemEngWrench && player.func_71045_bC().func_77960_j() > 0) {
                    int dam = player.func_71045_bC().func_77960_j();
                    if (dam == 1) {
                        ItemStack theStack = new ItemStack((Block)this, 1, 0);
                        for (int i = 0; i < 6; ++i) {
                            ts.getSide(ForgeDirection.getOrientation((int)i)).onSocketSave(ts.configs[i], ts, ForgeDirection.getOrientation((int)side));
                        }
                        NBTTagCompound data = new NBTTagCompound();
                        ts.func_145841_b(data);
                        theStack.func_77982_d(data);
                        if (!world.field_72995_K) {
                            float f = 0.7f;
                            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            EntityItem entityitem2 = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, theStack);
                            entityitem2.field_145804_b = 10;
                            world.func_72838_d((Entity)entityitem2);
                            for (int i = 0; i < 6; ++i) {
                                ts.getSide(ForgeDirection.getOrientation((int)i)).onSocketRemoved(ts.configs[i], ts, ForgeDirection.getOrientation((int)side), true);
                            }
                        }
                        this.wrenched = true;
                        world.func_147468_f(x, y, z);
                    } else {
                        int sideID = ts.sides[side];
                        if (sideID != 0 && !ts.sideLocked[side]) {
                            ItemStack theStack = new ItemStack(emasher.items.Items.module(), 1, sideID);
                            if (!world.field_72995_K) {
                                ForgeDirection d = ForgeDirection.getOrientation((int)side);
                                int xo = x + d.offsetX;
                                int yo = y + d.offsetY;
                                int zo = z + d.offsetZ;
                                float f = 0.7f;
                                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                                EntityItem entityitem3 = new EntityItem(world, (double)xo + d0, (double)yo + d1, (double)zo + d2, theStack);
                                entityitem3.field_145804_b = 5;
                                world.func_72838_d((Entity)entityitem3);
                                ts.getSide(d).onRemoved(ts, ts.configs[side], ForgeDirection.getOrientation((int)side));
                            }
                            ts.sides[side] = 0;
                            ts.resetConfig(side);
                        }
                    }
                } else if (player.func_70093_af()) {
                    ItemStack theStack = new ItemStack((Block)this, 1, 0);
                    NBTTagCompound data = new NBTTagCompound();
                    ts.func_145841_b(data);
                    theStack.func_77982_d(data);
                    if (!world.field_72995_K) {
                        float f = 0.7f;
                        double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                        entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, theStack);
                        entityitem.field_145804_b = 10;
                        world.func_72838_d((Entity)entityitem);
                        for (int i = 0; i < 6; ++i) {
                            ts.getSide(ForgeDirection.getOrientation((int)i)).onSocketRemoved(ts.configs[i], ts, ForgeDirection.getOrientation((int)side), true);
                        }
                    }
                    this.wrenched = true;
                    world.func_147468_f(x, y, z);
                    world.func_147475_p(x, y, z);
                } else {
                    int sideID = ts.sides[side];
                    if (sideID != 0 && !ts.sideLocked[side]) {
                        ItemStack theStack = new ItemStack(emasher.items.Items.module(), 1, sideID);
                        if (!world.field_72995_K) {
                            float f = 0.7f;
                            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                            entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, theStack);
                            entityitem.field_145804_b = 10;
                            world.func_72838_d((Entity)entityitem);
                            ts.getSide(ForgeDirection.getOrientation((int)side)).onRemoved(ts, ts.configs[side], ForgeDirection.getOrientation((int)side));
                        }
                        ts.sides[side] = 0;
                        ts.resetConfig(side);
                    }
                }
            } else if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == emasher.items.Items.module()) {
                if ((ts.sides[side] == 0 || player.field_71075_bZ.field_75098_d) && ModuleRegistry.getModule(player.func_71045_bC().func_77960_j()).canBeInstalled(ts, ForgeDirection.getOrientation((int)side))) {
                    ts.sides[side] = player.func_71045_bC().func_77960_j();
                    ts.resetConfig(side);
                    ts.getSide(ForgeDirection.getOrientation((int)side)).init(ts, ts.configs[side], ForgeDirection.getOrientation((int)side));
                    if (!player.field_71075_bZ.field_75098_d) {
                        --player.func_71045_bC().field_77994_a;
                    }
                }
            } else {
                SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)side));
                if (m.canModuleBeDyed() && player.func_71045_bC() != null) {
                    for (int i = 0; i < 16; ++i) {
                        if (!OreDictionary.itemMatches((ItemStack)player.func_71045_bC(), (ItemStack)new ItemStack(Items.field_151100_aR, 1, i), (boolean)true)) continue;
                        m.changeColour(i, ts.configs[side], ts, ForgeDirection.getOrientation((int)side));
                        --player.func_71045_bC().field_77994_a;
                        return true;
                    }
                }
                m.onSideActivated(ts, ts.configs[side], ForgeDirection.getOrientation((int)side), player, subX, subY, subZ);
            }
        }
        if (t instanceof TileSocket) {
            ts = (TileSocket)t;
            ItemStack item = player.func_71045_bC();
            if ((item == null || !(item.func_77973_b() instanceof IToolWrench) && item.func_77973_b() != emasher.items.Items.module() && item.func_77973_b() != emasher.items.Items.remote()) && side >= 0 && side < 6) {
                SocketModule m;
                int oreId = OreDictionary.getOreID((ItemStack)player.func_71045_bC());
                boolean wasDye = false;
                for (int i = 0; i < dyes.length; ++i) {
                    if (oreId != OreDictionary.getOreID((String)dyes[i])) continue;
                    wasDye = true;
                    break;
                }
                if ((m = ts.getSide(ForgeDirection.getOrientation((int)side))) != null && !wasDye) {
                    m.onSideActivatedClient(ts, ts.configs[side], ForgeDirection.getOrientation((int)side), player, subX, subY, subZ);
                }
            }
        }
        return true;
    }

    public void func_149724_b(World world, int x, int y, int z, Entity entity) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && t != null && t instanceof TileSocket) {
            TileSocket ts = (TileSocket)t;
            for (int i = 0; i < 6; ++i) {
                SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)i));
                m.onEntityWalkOn(ts, ts.configs[i], ForgeDirection.getOrientation((int)i), entity);
            }
        }
    }

    public void func_149725_f(World world, int x, int y, int z, int oldmeta) {
        if (this.wrenched) {
            return;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileSocket) {
            TileSocket ts = (TileSocket)te;
            for (int side = 0; side < 6; ++side) {
                int sideID = ts.sides[side];
                if (sideID == 0 || ts.sideLocked[side]) continue;
                ItemStack theStack = new ItemStack(emasher.items.Items.module(), 1, sideID);
                if (!world.field_72995_K) {
                    float f = 0.7f;
                    double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, theStack);
                    entityitem.field_145804_b = 10;
                    world.func_72838_d((Entity)entityitem);
                    ts.getSide(ForgeDirection.getOrientation((int)side)).onSocketRemoved(ts.configs[side], ts, ForgeDirection.getOrientation((int)side), false);
                }
                ts.sides[side] = 0;
                ts.resetConfig(side);
            }
        }
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
        par1World.func_147475_p(par2, par3, par4);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        this.wrenched = false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        IIcon result = this.field_149761_L;
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof TileSocket) {
            TileSocket ts = (TileSocket)t;
            SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)blockSide));
            SideConfig c = ts.configs[blockSide];
            int index = m.getCurrentTexture(c, ts, ForgeDirection.getOrientation((int)blockSide));
            result = this.textures[m.moduleID][index];
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        int i;
        this.field_149761_L = ir.func_94245_a("eng_toolbox:socketItem");
        this.textures = new IIcon[ModuleRegistry.numModules][];
        this.tankIndicator = new IIcon[4];
        this.inventoryIndicator = new IIcon[4];
        this.rsIndicator = new IIcon[8];
        this.latchIndicator = new IIcon[8];
        this.bar1 = new IIcon[8];
        this.bar2 = new IIcon[8];
        this.chargeInd = new IIcon[13];
        for (i = 0; i < ModuleRegistry.numModules; ++i) {
            SocketModule m = ModuleRegistry.getModule(i);
            if (i == 0) {
                this.textures[0] = new IIcon[1];
                this.textures[0][0] = ir.func_94245_a("eng_toolbox:bg");
                EngineersToolbox.innerTextures().put("eng_toolbox:inner_circuit", ir.func_94245_a("eng_toolbox:inner_circuit"));
                continue;
            }
            if (m == null) continue;
            int l = m.textureFiles.length;
            this.textures[i] = new IIcon[l];
            for (int j = 0; j < l; ++j) {
                this.textures[i][j] = ir.func_94245_a(m.textureFiles[j]);
            }
            String[] innerTextures = m.getAllInternalTextures();
            for (int j = 0; j < innerTextures.length; ++j) {
                String texture = innerTextures[j];
                if (EngineersToolbox.innerTextures().containsKey(texture)) continue;
                EngineersToolbox.innerTextures().put(texture, ir.func_94245_a(texture));
            }
        }
        for (i = -1; i < 3; ++i) {
            int temp = i == -1 ? 3 : i;
            this.tankIndicator[temp] = ir.func_94245_a("eng_toolbox:ind_l_" + i);
            this.inventoryIndicator[temp] = ir.func_94245_a("eng_toolbox:ind_i_" + i);
        }
        for (i = 0; i < 8; ++i) {
            this.rsIndicator[i] = ir.func_94245_a("eng_toolbox:ind_r_" + i);
            this.latchIndicator[i] = ir.func_94245_a("eng_toolbox:ind_a_" + i);
            this.bar1[i] = ir.func_94245_a("eng_toolbox:rsInd" + i);
            this.bar2[i] = ir.func_94245_a("eng_toolbox:timeInd" + i);
        }
        for (i = 0; i < 13; ++i) {
            this.chargeInd[i] = ir.func_94245_a("eng_toolbox:chargeInd" + i);
        }
        this.hasData = ir.func_94245_a("eng_toolbox:hasData");
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof TileSocket) {
            TileSocket ts = (TileSocket)t;
            SocketModule m = ts.getSide(ForgeDirection.getOrientation((int)side));
            return m.isRedstoneInterface();
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block nblock) {
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof TileSocket && !world.field_72995_K) {
            TileSocket ts = (TileSocket)t;
            for (int i = 0; i < 6; ++i) {
                boolean oldRS;
                boolean rs;
                ForgeDirection d = ForgeDirection.getOrientation((int)i);
                ForgeDirection opposite = d.getOpposite();
                SocketModule m = ts.getSide(opposite);
                if (nblock != Blocks.field_150488_af && ts.initialized) {
                    m.onAdjChange(ts, ts.configs[opposite.ordinal()], opposite);
                    ts.checkSideForChange(i);
                }
                if ((rs = world.func_94574_k(x + opposite.offsetX, y + opposite.offsetY, z + opposite.offsetZ, opposite.ordinal())) == (oldRS = ts.sideRS[opposite.ordinal()])) continue;
                ts.sideRS[opposite.ordinal()] = rs;
                m.updateRestone(rs, ts.configs[opposite.ordinal()], ts);
                EngineersToolbox.network().sendToDimension((IMessage)new SocketStateMessage(ts, (byte)opposite.ordinal()), ts.func_145831_w().field_73011_w.field_76574_g);
            }
        }
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        SideConfig c;
        TileSocket ts;
        SocketModule m;
        TileEntity t = world.func_147438_o(x, y, z);
        side = ForgeDirection.OPPOSITES[side];
        if (t != null && t instanceof TileSocket && (m = (ts = (TileSocket)t).getSide(ForgeDirection.getOrientation((int)side))).isOutputtingRedstone(c = ts.configs[side], ts)) {
            return 15;
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        SideConfig c;
        TileSocket ts;
        SocketModule m;
        TileEntity t = world.func_147438_o(x, y, z);
        side = ForgeDirection.OPPOSITES[side];
        if (t != null && t instanceof TileSocket && (m = (ts = (TileSocket)t).getSide(ForgeDirection.getOrientation((int)side))).isOutputtingRedstone(c = ts.configs[side], ts)) {
            return 15;
        }
        return 0;
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }
}

