/*
 * Decompiled with CFR 0.152.
 */
package emasher.blocks;

import emasher.EngineersToolbox;
import emasher.tileentities.TileGas;
import emasher.util.Config;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public abstract class BlockGasGeneric
extends BlockContainer
implements IFluidBlock {
    private static final int MIN_PRESSURE = 3;
    public boolean canExplode;
    public boolean canBurn;
    public boolean isDestructive;
    public Fluid blocksFluid;

    public BlockGasGeneric(int lightOpacity, boolean canExplode) {
        super(Material.field_151594_q);
        this.func_149713_g(lightOpacity);
        this.canExplode = canExplode;
        this.canBurn = false;
        this.isDestructive = false;
        this.func_149647_a(EngineersToolbox.tabBlocks());
    }

    public BlockGasGeneric(int lightOpacity, boolean canExplode, boolean canBurn, boolean isDestructive) {
        this(lightOpacity, canExplode);
        this.canBurn = canBurn;
        this.isDestructive = isDestructive;
    }

    public TileEntity func_149915_a(World var1, int metadata) {
        return new TileGas(this.getFluid());
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (block == Blocks.field_150480_ab || block == Blocks.field_150478_aa && world.field_73013_u == EnumDifficulty.HARD) {
            this.contactFire(world, x, y, z);
        }
    }

    public void contactFire(World world, int x, int y, int z) {
        if (this.canExplode && Config.gasBlocksCanExplode()) {
            world.func_147468_f(x, y, z);
            world.func_147475_p(x, y, z);
            world.func_72876_a(null, (double)x, (double)y, (double)z, 4.0f, true);
        } else if (this.canBurn) {
            int tempY = y - 1;
            while (world.func_147439_a(x, tempY, z) == this || world.func_147439_a(x, tempY, z) == Blocks.field_150350_a || world.func_147439_a(x, tempY, z).isReplaceable((IBlockAccess)world, x, tempY, z)) {
                --tempY;
            }
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
            world.func_147475_p(x, y, z);
            world.func_147449_b(x, ++tempY, z, (Block)Blocks.field_150480_ab);
        }
    }

    public boolean isReplaceable(IBlockAccess world, int i, int j, int k) {
        return true;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        if (!Config.gasBlocksInWorld()) {
            world.func_147468_f(x, y, z);
            return;
        }
        TileEntity t = world.func_147438_o(x, y, z);
        if (t != null && t instanceof TileGas) {
            TileGas tg = (TileGas)t;
            int vol = tg.getGasAmount();
            int meta = vol * 15 / 4000;
            world.func_72921_c(x, y, z, meta, 4);
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        this.contactFire(world, x, y, z);
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return null;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public Fluid getFluid() {
        return this.blocksFluid;
    }

    public FluidStack drain(World world, int x, int y, int z, boolean doDrain) {
        boolean amnt = false;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileGas) {
            TileGas tg = (TileGas)te;
            FluidStack result = tg.getGas();
            if (doDrain) {
                world.func_147468_f(x, y, z);
                world.func_147475_p(x, y, z);
            }
            return result;
        }
        return null;
    }

    public boolean canDrain(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof TileGas;
    }

    public boolean canDestroyBlock(Block block, int x, int y, int z, World world) {
        return false;
    }

    public float getFilledPercentage(World world, int x, int y, int z) {
        return 1.0f;
    }
}

