/*
 * Decompiled with CFR 0.152.
 */
package emasher.api;

import emasher.api.Util;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CentrifugeRecipeRegistry {
    public static ArrayList<CentrifugeRecipe> recipes = new ArrayList();

    public static void registerRecipe(CentrifugeRecipe recipe) {
        recipes.add(recipe);
    }

    public static void registerRecipe(ItemStack input, ItemStack output, ItemStack secondaryOutput, int percent) {
        CentrifugeRecipeRegistry.registerRecipe(new CentrifugeRecipe(input, output, secondaryOutput, percent));
    }

    public static void registerRecipe(String input, ItemStack output, ItemStack secondaryOutput, int percent) {
        CentrifugeRecipeRegistry.registerRecipe(new CentrifugeRecipe(input, output, secondaryOutput, percent));
    }

    public static void registerRecipe(String input, String output, String secondaryOutput, int percent) {
        CentrifugeRecipeRegistry.registerRecipe(new CentrifugeRecipe(input, output, secondaryOutput, percent));
    }

    public static CentrifugeRecipe getRecipe(Object input) {
        block9: {
            block8: {
                if (!(input instanceof ItemStack)) break block8;
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)((ItemStack)input));
                for (CentrifugeRecipe r : recipes) {
                    int[] otherIDs = null;
                    if (r.getInput() instanceof ItemStack) {
                        otherIDs = OreDictionary.getOreIDs((ItemStack)((ItemStack)r.getInput()));
                    } else if (r.getInput() instanceof String) {
                        otherIDs = new int[]{OreDictionary.getOreID((String)((String)r.getInput()))};
                    }
                    if (!Util.checkArrays(oreIDs, otherIDs) && (!(r.getInput() instanceof ItemStack) || !((ItemStack)input).func_77969_a((ItemStack)r.getInput())) || r.getOutput() == null) continue;
                    return r;
                }
                break block9;
            }
            if (!(input instanceof String)) break block9;
            int[] oreIDs = new int[]{OreDictionary.getOreID((String)((String)input))};
            for (CentrifugeRecipe r : recipes) {
                int[] otherIDs = null;
                if (r.getInput() instanceof ItemStack) {
                    otherIDs = OreDictionary.getOreIDs((ItemStack)((ItemStack)r.getInput()));
                } else if (r.getInput() instanceof String) {
                    otherIDs = new int[]{OreDictionary.getOreID((String)((String)r.getInput()))};
                }
                if (!Util.checkArrays(oreIDs, otherIDs) || r.getOutput() == null) continue;
                return r;
            }
        }
        return null;
    }

    public static class CentrifugeRecipe {
        private Object input;
        private Object output;
        private Object secondaryOutput;
        private int percent;

        public CentrifugeRecipe(ItemStack input, ItemStack output, ItemStack secondaryOutput, int percent) {
            this.input = input;
            this.output = output;
            this.secondaryOutput = secondaryOutput;
            this.percent = percent;
            ((ItemStack)this.output).field_77994_a = 1;
            ((ItemStack)this.secondaryOutput).field_77994_a = 1;
        }

        public CentrifugeRecipe(String input, ItemStack output, ItemStack secondaryOutput, int percent) {
            this.input = input;
            this.output = output;
            this.secondaryOutput = secondaryOutput;
            this.percent = percent;
            ((ItemStack)this.output).field_77994_a = 1;
            ((ItemStack)this.secondaryOutput).field_77994_a = 1;
        }

        public CentrifugeRecipe(String input, String output, String secondaryOutput, int percent) {
            this.input = input;
            this.output = output;
            this.secondaryOutput = secondaryOutput;
            this.percent = percent;
        }

        public Object getInput() {
            return this.input;
        }

        public ItemStack getOutput() {
            if (this.output instanceof String) {
                ArrayList ores = OreDictionary.getOres((String)((String)this.output));
                if (ores.size() > 0) {
                    ItemStack stack = ((ItemStack)ores.get(0)).func_77946_l();
                    stack.field_77994_a = 1;
                    this.output = stack;
                } else {
                    return null;
                }
            }
            return (ItemStack)this.output;
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput instanceof String) {
                ArrayList ores = OreDictionary.getOres((String)((String)this.secondaryOutput));
                if (ores.size() > 0) {
                    ItemStack stack = ((ItemStack)ores.get(0)).func_77946_l();
                    stack.field_77994_a = 1;
                    this.secondaryOutput = stack;
                } else {
                    return null;
                }
            }
            return (ItemStack)this.secondaryOutput;
        }

        public int getPercent() {
            return this.percent;
        }

        public boolean shouldOuputSecondary(Random r) {
            if (this.secondaryOutput instanceof String && this.getSecondaryOutput() == null) {
                return false;
            }
            return r.nextInt(100) < this.percent;
        }
    }
}

