/*
 * Decompiled with CFR 0.152.
 */
package com.insane.simplelabels.tile;

import com.insane.simplelabels.MessageLabelUpdate;
import com.insane.simplelabels.PacketHandler;
import com.insane.simplelabels.SimpleLabels;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileLabel
extends TileEntity {
    private ItemStack storedItem;
    private ItemStack storedItemForRender;
    private IDeepStorageUnit dsu;
    private ForgeDirection dsuDirection = ForgeDirection.UNKNOWN;
    private int placedDirection;
    private long clickTime = -20L;

    public void init(int meta) {
        this.dsuDirection = ForgeDirection.getOrientation((int)meta);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.dsu = this.getDSU();
            if (this.dsu != null && !ItemStack.func_77989_b((ItemStack)this.getLabelStack(false), (ItemStack)this.dsu.getStoredItemType())) {
                this.setLabelStack(this.dsu.getStoredItemType());
                this.func_70296_d();
                this.sendPacket();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public boolean onRightClick(boolean sneaking) {
        this.dsu = this.getDSU();
        if (this.dsu == null) {
            return false;
        }
        ItemStack stored = this.dsu.getStoredItemType();
        if (stored == null) {
            return false;
        }
        if (this.field_145850_b.func_82737_E() - this.clickTime > 2L) {
            int extractAmount;
            int n = extractAmount = sneaking ? stored.func_77976_d() : 1;
            if (extractAmount > stored.field_77994_a) {
                extractAmount = stored.field_77994_a;
            }
            EntityItem dropItem = new EntityItem(this.field_145850_b);
            ItemStack dropStack = stored.func_77946_l();
            dropStack.field_77994_a = extractAmount;
            dropItem.func_92058_a(dropStack);
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.placedDirection);
            dropItem.func_70107_b((double)this.field_145851_c + 0.5 + (double)dir.offsetX, (double)this.field_145848_d + 0.5 + (double)dir.offsetY, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ);
            float var15 = 0.05f;
            dropItem.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * var15;
            dropItem.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * var15 + 0.2f;
            dropItem.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * var15;
            this.field_145850_b.func_72838_d((Entity)dropItem);
            this.dsu.setStoredItemCount(stored.field_77994_a - extractAmount);
            this.clickTime = this.field_145850_b.func_82737_E();
            return true;
        }
        return false;
    }

    public void addFromPlayer(EntityPlayer player) {
        ItemStack heldStack = player.field_71071_by.func_70448_g();
        if (heldStack != null) {
            heldStack.field_77994_a -= this.addStack(heldStack);
            if (heldStack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
        if (this.field_145850_b.func_82737_E() - this.clickTime < 10L) {
            InventoryPlayer playerInv = player.field_71071_by;
            for (int invSlot = 0; invSlot < playerInv.func_70302_i_(); ++invSlot) {
                ItemStack slotStack = playerInv.func_70301_a(invSlot);
                int input = this.addStack(slotStack);
                if (input <= 0) continue;
                slotStack.field_77994_a -= input;
                if (slotStack.field_77994_a != 0) continue;
                playerInv.func_70299_a(invSlot, (ItemStack)null);
            }
        }
        this.clickTime = this.field_145850_b.func_82737_E();
        SimpleLabels.proxy.updatePlayerInventory(player);
        this.func_70296_d();
    }

    private int addStack(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        this.dsu = this.getDSU();
        if (this.dsu == null) {
            return 0;
        }
        ItemStack stored = this.dsu.getStoredItemType();
        if (stored == null) {
            this.dsu.setStoredItemType(stack, stack.field_77994_a);
            if (TileLabel.stacksEqual(stack, this.dsu.getStoredItemType(), true)) {
                return stack.field_77994_a;
            }
            return 0;
        }
        if (TileLabel.stacksEqual(stored, stack, true)) {
            int addAmount = stack.field_77994_a;
            if (this.dsu.getMaxStoredCount() < stored.field_77994_a + stack.field_77994_a) {
                addAmount = this.dsu.getMaxStoredCount() - stored.field_77994_a;
            }
            this.dsu.setStoredItemCount(stored.field_77994_a + addAmount);
            return addAmount;
        }
        return 0;
    }

    public static boolean stacksEqual(ItemStack s1, ItemStack s2, boolean nbtSensitive) {
        if (s1 == null | s2 == null) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        if (!nbtSensitive) {
            return true;
        }
        if (s1.func_77978_p() == s2.func_77978_p()) {
            return true;
        }
        if (s1.func_77978_p() == null || s2.func_77978_p() == null) {
            return false;
        }
        return s1.func_77978_p().equals((Object)s2.func_77978_p());
    }

    public void setPlacedDirection(int newDirection) {
        this.placedDirection = newDirection;
    }

    public int getPlacedDirection() {
        return this.placedDirection;
    }

    private IDeepStorageUnit getDSU() {
        return (IDeepStorageUnit)this.field_145850_b.func_147438_o(this.field_145851_c - this.dsuDirection.offsetX, this.field_145848_d - this.dsuDirection.offsetY, this.field_145849_e - this.dsuDirection.offsetZ);
    }

    public boolean hasDSU() {
        return this.getDSU() != null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.dsu == null ? super.getRenderBoundingBox() : ((TileEntity)this.dsu).getRenderBoundingBox();
    }

    private void sendPacket() {
        PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageLabelUpdate(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getLabelStack(false)), this.field_145850_b.field_73011_w.field_76574_g);
    }

    public ItemStack getLabelStack(boolean forRender) {
        return forRender ? this.storedItemForRender : this.storedItem;
    }

    public void setLabelStack(ItemStack inputStack) {
        if (this.field_145850_b != null) {
            this.dsu = this.getDSU();
        }
        if (inputStack != null) {
            this.storedItem = inputStack.func_77946_l();
            this.storedItemForRender = inputStack.func_77946_l();
            this.storedItemForRender.field_77994_a = 1;
        } else {
            this.storedItemForRender = null;
            this.storedItem = null;
        }
    }

    public ForgeDirection getDsuDirection() {
        return this.dsuDirection;
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        this.dsu = this.getDSU();
    }

    public void func_145841_b(NBTTagCompound tag) {
        if (this.getLabelStack(false) != null) {
            NBTTagCompound item = new NBTTagCompound();
            this.getLabelStack(false).func_77955_b(item);
            item.func_74768_a("actualSize", this.getLabelStack((boolean)false).field_77994_a);
            tag.func_74782_a("storedItem", (NBTBase)item);
        }
        tag.func_74778_a("dsuDir", this.dsuDirection.name());
        tag.func_74768_a("renderDirection", this.placedDirection);
        tag.func_74772_a("clickTime", this.clickTime);
        super.func_145841_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        if (tag.func_74764_b("storedItem")) {
            NBTTagCompound item = tag.func_74775_l("storedItem");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)item);
            stack.field_77994_a = item.func_74762_e("actualSize");
            this.setLabelStack(stack);
        }
        this.dsuDirection = ForgeDirection.valueOf((String)tag.func_74779_i("dsuDir"));
        this.placedDirection = tag.func_74762_e("renderDirection");
        this.clickTime = tag.func_74763_f("clickTime");
        super.func_145839_a(tag);
    }
}

