/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.crossmod.appeng;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.tile.grid.AENetworkTile;
import appeng.tile.storage.TileChest;
import appeng.tile.storage.TileDrive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import shedar.mods.ic2.nuclearcontrol.utils.NCLog;

public class TileEntityNetworkLink
extends AENetworkTile {
    private static int TOTALBYTES = 0;
    private static int USEDBYTES = 0;
    private static int ITEMTYPETOTAL = 0;
    private static int USEDITEMTYPE = 0;

    public TileEntityNetworkLink() {
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.SMART;
    }

    public void updateNetworkCache() {
        int CacheByteT = 0;
        int CacheByte = 0;
        int CacheItemT = 0;
        int CacheItem = 0;
        List<TileEntity> tileEntity = this.getTiles();
        for (int i = 0; i < tileEntity.size(); ++i) {
            ICellInventoryHandler handler;
            ICellInventory cellInventory;
            IMEInventoryHandler inventory;
            TileChest chest;
            ItemStack is;
            TileEntity tile = tileEntity.get(i);
            if (tile instanceof TileDrive) {
                TileDrive drive = (TileDrive)tile;
                for (int x = 0; x < drive.getInternalInventory().func_70302_i_(); ++x) {
                    ICellInventoryHandler handler2;
                    ICellInventory cellInventory2;
                    IMEInventoryHandler inventory2;
                    ItemStack is2 = drive.getInternalInventory().func_70301_a(x);
                    if (is2 == null || !((inventory2 = AEApi.instance().registries().cell().getCellInventory(is2, null, StorageChannel.ITEMS)) instanceof ICellInventoryHandler) || (cellInventory2 = (handler2 = (ICellInventoryHandler)inventory2).getCellInv()) == null) continue;
                    CacheByteT = (int)((long)CacheByteT + cellInventory2.getTotalBytes());
                    CacheByte = (int)((long)CacheByte + cellInventory2.getUsedBytes());
                    CacheItemT = (int)((long)CacheItemT + cellInventory2.getTotalItemTypes());
                    CacheItem = (int)((long)CacheItem + cellInventory2.getStoredItemTypes());
                }
                continue;
            }
            if (!(tile instanceof TileChest) || (is = (chest = (TileChest)tile).getInternalInventory().func_70301_a(0)) == null || !((inventory = AEApi.instance().registries().cell().getCellInventory(is, null, StorageChannel.ITEMS)) instanceof ICellInventoryHandler) || (cellInventory = (handler = (ICellInventoryHandler)inventory).getCellInv()) == null) continue;
            CacheByteT = (int)((long)CacheByteT + cellInventory.getTotalBytes());
            CacheByte = (int)((long)CacheByte + cellInventory.getUsedBytes());
            CacheItemT = (int)((long)CacheItemT + cellInventory.getTotalItemTypes());
            CacheItem = (int)((long)CacheItem + cellInventory.getStoredItemTypes());
        }
        if (CacheByteT != TOTALBYTES) {
            TOTALBYTES = CacheByteT;
        }
        if (CacheByte != USEDBYTES) {
            USEDBYTES = CacheByte;
        }
        if (CacheItemT != ITEMTYPETOTAL) {
            ITEMTYPETOTAL = CacheItemT;
        }
        if (CacheItem != USEDITEMTYPE) {
            USEDITEMTYPE = CacheItem;
        }
    }

    private List<TileEntity> getTiles() {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        try {
            IGrid grid = this.getProxy().getNode().getGrid();
            for (Class clazz : grid.getMachinesClasses()) {
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (clazz2 != IChestOrDrive.class) continue;
                    for (IGridNode con : grid.getMachines(TileDrive.class)) {
                        list.add(TileEntityNetworkLink.getBaseTileEntity(con.getGridBlock().getLocation()));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private static TileEntity getBaseTileEntity(DimensionalCoord coord) {
        if (coord == null) {
            NCLog.fatal("Coord is null");
            return null;
        }
        World world = coord.getWorld();
        if (world == null) {
            NCLog.fatal("World is null?");
            return null;
        }
        return world.func_147438_o(coord.x, coord.y, coord.z);
    }

    @MENetworkEventSubscribe
    public void updateviaCellEvent(MENetworkCellArrayUpdate e) {
        this.updateNetworkCache();
    }

    @MENetworkEventSubscribe
    public void updateviaStorageEvent(MENetworkStorageEvent e) {
        this.updateNetworkCache();
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        syncData.func_74768_a("TotalBytes", TOTALBYTES);
        syncData.func_74768_a("UsedBytes", USEDBYTES);
        syncData.func_74768_a("TotalItems", ITEMTYPETOTAL);
        syncData.func_74768_a("UsedItems", USEDITEMTYPE);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        TOTALBYTES = pkt.func_148857_g().func_74762_e("TotalBytes");
        USEDBYTES = pkt.func_148857_g().func_74762_e("UsedBytes");
        ITEMTYPETOTAL = pkt.func_148857_g().func_74762_e("TotalItems");
        USEDITEMTYPE = pkt.func_148857_g().func_74762_e("UsedItems");
    }

    public static int getTOTALBYTES() {
        return TOTALBYTES;
    }

    public static int getUSEDBYTES() {
        return USEDBYTES;
    }

    public static int getITEMTYPETOTAL() {
        return ITEMTYPETOTAL;
    }

    public static int getUSEDITEMTYPE() {
        return USEDITEMTYPE;
    }
}

