/*
 * Decompiled with CFR 0.152.
 */
package info.inpureprojects.core.Updater;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import info.inpureprojects.core.API.IUpdateCheck;
import info.inpureprojects.core.API.ReleaseLevel;
import info.inpureprojects.core.INpureCore;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.io.IOUtils;

public class UpdateManager {
    private UThread thread;
    private int lastPoll = 400;
    private boolean alreadyDisplayed = false;

    public UpdateManager(IUpdateCheck check) {
        this.thread = new UThread(check);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void runCheck() {
        this.thread.start();
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.lastPoll > 0) {
            --this.lastPoll;
            return;
        }
        this.lastPoll = 400;
        if (!this.thread.update.getLevel().equals((Object)ReleaseLevel.PUBLIC)) {
            FMLCommonHandler.instance().bus().unregister((Object)this);
            return;
        }
        if (!this.alreadyDisplayed && this.thread.checkComplete && this.thread.updateAvailable) {
            EntityPlayer player = evt.player;
            player.func_145747_a(new ChatComponentText(EnumChatFormatting.GOLD + "[" + this.thread.update.getModName() + "]:").func_150258_a(EnumChatFormatting.WHITE + " A new version is available: " + EnumChatFormatting.AQUA + this.thread.latestVersion.replace("1.7.10", "") + EnumChatFormatting.WHITE));
            this.alreadyDisplayed = true;
            FMLCommonHandler.instance().bus().unregister((Object)this);
        }
    }

    public static class UThread
    extends Thread {
        private final IUpdateCheck update;
        private boolean updateAvailable = false;
        private boolean checkComplete = false;
        private String latestVersion;

        public UThread(IUpdateCheck update) {
            super(update.getModId() + "UpdateCheck");
            this.update = update;
        }

        @Override
        public void run() {
            super.run();
            try {
                URL u = new URL(this.update.getUpdateUrl());
                BufferedReader in = new BufferedReader(new InputStreamReader(u.openStream()));
                List lines = IOUtils.readLines((Reader)in);
                this.latestVersion = ((String)lines.get(0)).split("\\s+")[0];
                INpureCore.proxy.print("Local: " + this.update.getVersion() + ", Remote: " + this.latestVersion);
                if (!this.latestVersion.equals(this.update.getVersion())) {
                    this.updateAvailable = true;
                    INpureCore.proxy.print("Update found for " + this.update.getModName());
                } else {
                    INpureCore.proxy.print("No update found for " + this.update.getModName());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.checkComplete = false;
            }
            this.checkComplete = true;
        }
    }
}

