/*
 * Decompiled with CFR 0.152.
 */
package info.inpureprojects.core.Scripting.Dynamic;

import info.inpureprojects.core.API.Scripting.IScriptingCore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.Invocable;

public class DynamicFactory {
    public static final DynamicFactory instance = new DynamicFactory();

    public Object create(IScriptingCore core, Object obj, Class Interface) {
        try {
            DynamicHandler h = new DynamicHandler(core, obj);
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Interface}, (InvocationHandler)h);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static abstract class specialHandler {
        public abstract void handle(Object var1, String var2, Object[] var3);

        public abstract boolean isObjectCompatible(Object var1);
    }

    public static class DynamicHandler
    implements InvocationHandler {
        private IScriptingCore core;
        private Object scriptClass;

        public DynamicHandler(IScriptingCore core, Object scriptClass) {
            this.core = core;
            this.scriptClass = scriptClass;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (this.core.getEngine() instanceof Invocable) {
                    Invocable invoc = (Invocable)((Object)this.core.getEngine());
                    return invoc.invokeMethod(this.scriptClass, method.getName(), args);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            return null;
        }
    }
}

