/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons.client.renderer;

import com.jaquadro.minecraft.extrabuttons.block.DelayButton;
import com.jaquadro.minecraft.extrabuttons.client.ClientProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class DelayButtonRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        DelayButton dbBlock = (DelayButton)block;
        if (dbBlock == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5625f, (float)-0.0625f);
        dbBlock.setBlockForPanelRender(DelayButton.defaultTileEntity);
        renderer.func_147775_a(block);
        this.renderStandaloneBlock(renderer, block);
        dbBlock.setBlockForButtonRender(DelayButton.defaultTileEntity);
        renderer.func_147775_a(block);
        this.renderStandaloneBlock(renderer, block);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        DelayButton dbBlock = (DelayButton)block;
        if (dbBlock == null) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        dbBlock.setBlockForPanelRender(te);
        renderer.func_147775_a((Block)dbBlock);
        renderer.func_147784_q(block, x, y, z);
        dbBlock.setBlockForButtonRender(te);
        renderer.func_147775_a(block);
        renderer.func_147784_q(block, x, y, z);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ClientProxy.delayButtonRenderID;
    }

    private void renderStandaloneBlock(RenderBlocks renderBlocks, Block block) {
        this.renderStandaloneBlock(renderBlocks, block, 1.0f, 1.0f, 1.0f);
    }

    private void renderStandaloneBlock(RenderBlocks renderBlocks, Block block, float r, float g, float b) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78386_a(0.5f * r, 0.5f * g, 0.5f * b);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderBlocks.func_147768_a(block, 0.0, 0.0, 0.0, block.func_149733_h(0));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78386_a(1.0f * r, 1.0f * g, 1.0f * b);
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderBlocks.func_147806_b(block, 0.0, 0.0, 0.0, block.func_149733_h(1));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderBlocks.func_147761_c(block, 0.0, 0.0, 0.0, block.func_149733_h(2));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78386_a(0.8f * r, 0.8f * g, 0.8f * b);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderBlocks.func_147734_d(block, 0.0, 0.0, 0.0, block.func_149733_h(3));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78386_a(0.6f * r, 0.6f * g, 0.6f * b);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderBlocks.func_147798_e(block, 0.0, 0.0, 0.0, block.func_149733_h(4));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78386_a(0.6f * r, 0.6f * g, 0.6f * b);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderBlocks.func_147764_f(block, 0.0, 0.0, 0.0, block.func_149733_h(5));
        tessellator.func_78381_a();
    }
}

