/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.extrabuttons.block;

import com.jaquadro.minecraft.extrabuttons.block.PlayerDetectorRail;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PlayerPoweredRail
extends PlayerDetectorRail {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public PlayerPoweredRail() {
        this.func_149675_a(true);
    }

    @Override
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        int data;
        if (!world.field_72995_K && ((data = world.func_72805_g(x, y, z)) & 8) == 0) {
            this.setStateIfMinecartInteractsWithRail(world, x, y, z, data);
        }
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int data;
        if (!world.field_72995_K && ((data = world.func_72805_g(x, y, z)) & 8) != 0) {
            this.setStateIfMinecartInteractsWithRail(world, x, y, z, data);
        }
    }

    private void setStateIfMinecartInteractsWithRail(World world, int x, int y, int z, int data) {
        EntityMinecart minecart;
        boolean isPowerBitSet = (data & 8) != 0;
        boolean isValidTarget = false;
        float boundAdjust = 0.125f;
        List entities = world.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72330_a((double)((float)x + boundAdjust), (double)y, (double)((float)z + boundAdjust), (double)((float)(x + 1) - boundAdjust), (double)((float)(y + 1) - boundAdjust), (double)((float)(z + 1) - boundAdjust)));
        if (!entities.isEmpty()) {
            for (Object item : entities) {
                minecart = (EntityMinecart)item;
                if (minecart.field_70153_n == null) continue;
                isValidTarget = true;
            }
        }
        if (isValidTarget && !isPowerBitSet) {
            world.func_72921_c(x, y, z, data | 8, 3);
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
            world.func_147458_c(x, y, z, x, y, z);
        }
        if (!isValidTarget && isPowerBitSet) {
            world.func_72921_c(x, y, z, data & 7, 3);
            world.func_147459_d(x, y, z, (Block)this);
            world.func_147459_d(x, y - 1, z, (Block)this);
            world.func_147458_c(x, y, z, x, y, z);
        }
        if (isValidTarget) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
        data = world.func_72805_g(x, y, z);
        for (Object item : entities) {
            minecart = (EntityMinecart)item;
            if (minecart == null) continue;
            this.updateMinecart(minecart, data);
        }
    }

    private void updateMinecart(EntityMinecart entity, int railData) {
        boolean isPoweredBitSet;
        int direction = railData & 7;
        boolean bl = isPoweredBitSet = (railData & 8) != 0;
        if (entity.shouldDoRailFunctions()) {
            int posX = MathHelper.func_76128_c((double)entity.field_70165_t);
            int posY = MathHelper.func_76128_c((double)entity.field_70163_u);
            int posZ = MathHelper.func_76128_c((double)entity.field_70161_v);
            double motion = Math.sqrt(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y);
            if (isPoweredBitSet) {
                if (motion > 0.01) {
                    double boost = 0.06;
                    entity.field_70159_w += entity.field_70159_w / motion * boost;
                    entity.field_70179_y += entity.field_70179_y / motion * boost;
                } else if (direction == 1) {
                    if (entity.field_70170_p.func_147445_c(posX - 1, posY, posZ, true)) {
                        entity.field_70159_w = 0.04;
                    } else if (entity.field_70170_p.func_147445_c(posX + 1, posY, posZ, true)) {
                        entity.field_70159_w = -0.04;
                    }
                } else if (direction == 0) {
                    if (entity.field_70170_p.func_147445_c(posX, posY, posZ - 1, true)) {
                        entity.field_70179_y = 0.04;
                    } else if (entity.field_70170_p.func_147445_c(posX, posY, posZ + 1, true)) {
                        entity.field_70179_y = -0.04;
                    }
                }
            } else if (motion < 0.03) {
                entity.field_70159_w *= 0.0;
                entity.field_70181_x *= 0.0;
                entity.field_70179_y *= 0.0;
            } else {
                entity.field_70159_w *= 0.5;
                entity.field_70181_x *= 0.0;
                entity.field_70179_y *= 0.5;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int data) {
        if ((data & 8) != 0) {
            return this.iconArray[1];
        }
        return this.iconArray[0];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconArray = new IIcon[]{iconRegister.func_94245_a("extrabuttons:player_powered_rail_off"), iconRegister.func_94245_a("extrabuttons:player_powered_rail_on")};
    }
}

