/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.coremod;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class MinecraftClassTransformer
implements IClassTransformer {
    public static final Logger logger = LogManager.getLogger();
    public static final String OBF_CLASS = "bao";
    public static final String MCP_CLASS = "net.minecraft.client.Minecraft";
    public static final String OBF_METHOD = "func_147112_ai";
    public static final String MCP_METHOD = "func_147112_ai";
    private static final String METHOD_DESC = "()V";

    public byte[] transform(String className, String transformedClassName, byte[] bytes) {
        String methodName;
        if (className.equals(OBF_CLASS)) {
            methodName = "func_147112_ai";
        } else if (className.equals(MCP_CLASS)) {
            methodName = "func_147112_ai";
        } else {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(METHOD_DESC)) continue;
            logger.info("TrashSlot will now patch {} in {}...", new Object[]{methodName, className});
            AbstractInsnNode insertAfter = null;
            for (int i = 0; i < method.instructions.size(); ++i) {
                AbstractInsnNode node = method.instructions.get(i);
                if (!(node instanceof VarInsnNode) || node.getOpcode() != 54 || ((VarInsnNode)node).var != 2) continue;
                insertAfter = node;
                break;
            }
            if (insertAfter != null) {
                MethodNode mn = new MethodNode();
                mn.visitIincInsn(2, -1);
                method.instructions.insert(insertAfter, mn.instructions);
                logger.info("TrashSlot successfully patched {} in {}!", new Object[]{methodName, className});
                continue;
            }
            logger.warn("TrashSlot failed to patch {0}::{1} ({2} not found) - pick block in creative will be weird!", new Object[]{className, methodName, "ISTORE 2"});
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

