/*
 * Decompiled with CFR 0.152.
 */
package latmod.xpt;

import ftb.lib.FTBLib;
import ftb.lib.api.config.ConfigEntryBool;
import ftb.lib.api.config.ConfigEntryInt;
import ftb.lib.api.config.ConfigFile;
import ftb.lib.api.config.ConfigRegistry;
import java.io.File;
import latmod.lib.annotations.Flags;
import latmod.lib.annotations.Info;
import latmod.lib.annotations.NumberBounds;
import net.minecraft.entity.player.EntityPlayer;

public class XPTConfig {
    public static final ConfigFile configFile = new ConfigFile("xpt");
    @NumberBounds(min=0.0, max=200.0)
    @Info(value={"Levels required to teleport in same dimension"})
    public static final ConfigEntryInt levels_for_1000_blocks = new ConfigEntryInt("levels_for_1000_blocks", 20);
    @NumberBounds(min=0.0, max=200.0)
    @Info(value={"Levels required to teleport to another dimension"})
    public static final ConfigEntryInt levels_for_crossdim = new ConfigEntryInt("levels_for_crossdim", 30);
    @Flags(value={0})
    @NumberBounds(min=1.0, max=3600.0)
    @Info(value={"Teleporter cooldown"})
    public static final ConfigEntryInt cooldown_seconds = new ConfigEntryInt("cooldown_seconds", 3);
    @Info(value={"Enable crafting recipes"})
    public static final ConfigEntryBool enable_crafting = new ConfigEntryBool("enable_crafting", true);
    @Info(value={"Only linking will cost levels, teleporting will be free"})
    public static final ConfigEntryBool only_linking_uses_xp = new ConfigEntryBool("only_linking_uses_xp", false);
    @Flags(value={0})
    @Info(value={"Soft blocks are like torches - you can walk trough them, BUT it solved the 'getting stuck in block' issue"})
    public static final ConfigEntryBool soft_blocks = new ConfigEntryBool("soft_blocks", true);
    @NumberBounds(min=-1.0, max=200.0)
    @Info(value={"-1 - Disabled", "0+ - Enables Recall Remote crafting and usage"})
    public static final ConfigEntryInt levels_for_recall = new ConfigEntryInt("levels_for_recall", -1);

    public static void load() {
        configFile.setFile(new File(FTBLib.folderConfig, "/LatMod/XPT.json"));
        configFile.setDisplayName("XPTeleporters");
        configFile.addGroup("general", XPTConfig.class);
        ConfigRegistry.add((ConfigFile)configFile);
        configFile.load();
    }

    public static boolean canConsumeLevels(EntityPlayer ep, int levels) {
        if (levels <= 0 || ep.field_71075_bZ.field_75098_d) {
            return true;
        }
        return ep.field_71068_ca >= levels;
    }

    public static void consumeLevels(EntityPlayer ep, int levels) {
        if (levels <= 0 || ep.field_71075_bZ.field_75098_d) {
            return;
        }
        ep.func_82242_a(-levels);
    }

    public static int cooldownTicks() {
        return cooldown_seconds.get() * 20;
    }
}

