/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NEICrusherHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(4, 4, 58, 40), "ieCrusher", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (CrusherRecipe r : CrusherRecipe.recipeList) {
                if (r == null || r.output == null) continue;
                this.arecipes.add(new CachedCrusherRecipe(r));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.ImmersiveEngineering.metalMultiblock.crusher.name");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/blastFurnace.png";
    }

    public String getOverlayIdentifier() {
        return "ieCrusher";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (CrusherRecipe r : CrusherRecipe.recipeList) {
                if (r == null || !Utils.stackMatchesObject(result, r.output) && (r.secondaryOutput == null || !Utils.stackMatchesObject(result, r.secondaryOutput))) continue;
                this.arecipes.add(new CachedCrusherRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        CrusherRecipe r;
        if (ingredient != null && (r = CrusherRecipe.findRecipe(ingredient)) != null && r.output != null) {
            this.arecipes.add(new CachedCrusherRecipe(r));
        }
    }

    public void drawBackground(int recipe) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CachedCrusherRecipe r = (CachedCrusherRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            ClientUtils.drawSlot(r.input.relx, r.input.rely, 16, 16);
            ClientUtils.drawSlot(r.output.relx, r.output.rely, 16, 16);
            if (r.secondary != null) {
                for (PositionedStack ps : r.secondary) {
                    ClientUtils.drawSlot(ps.relx, ps.rely, 16, 16);
                }
            }
            String s = r.energy + " RF";
            ClientUtils.font().func_85187_a(s, 120 - ClientUtils.font().func_78256_a(s) / 2, 20, 0x777777, false);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)"textures/gui/container/furnace.png");
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GuiDraw.drawTexturedModalRect((int)18, (int)-85, (int)82, (int)35, (int)20, (int)15);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)40.0f, (float)40.0f, (float)100.0f);
            GL11.glRotatef((float)-15.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)200.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)10.0f, (float)-10.0f, (float)10.0f);
            TileEntityCrusher gen = new TileEntityCrusher();
            gen.pos = 17;
            gen.formed = true;
            ClientUtils.bindAtlas(0);
            ClientUtils.tes().func_78382_b();
            ClientUtils.handleStaticTileRenderer(gen, false);
            ClientUtils.tes().func_78381_a();
            TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)gen, 0.0, 0.0, 0.0, 0.0f);
        }
        GL11.glPopMatrix();
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - (gui.field_146294_l - 176) / 2 - offset.x, mouse.y - (gui.field_146295_m - 166) / 2 - offset.y);
        CachedCrusherRecipe r = (CachedCrusherRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null && r.secondary != null) {
            for (int i = 0; i < r.secondary.length; ++i) {
                if (!new Rectangle(r.secondary[i].relx - 1, r.secondary[i].rely - 1, 18, 18).contains(relMouse) || !r.secondary[i].contains(stack)) continue;
                currenttip.add(String.format("%s %.0f%%", StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.info.chance"), Float.valueOf(r.secondaryChance[i] * 100.0f)));
            }
        }
        return currenttip;
    }

    public class CachedCrusherRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        PositionedStack[] secondary;
        public float[] secondaryChance;
        public int energy;

        public CachedCrusherRecipe(CrusherRecipe recipe) {
            super((TemplateRecipeHandler)NEICrusherHandler.this);
            Object in = recipe.input;
            this.input = new PositionedStack(in, 70, 0);
            this.output = new PositionedStack((Object)recipe.output, 70, 40);
            if (recipe.secondaryOutput != null) {
                this.secondary = new PositionedStack[recipe.secondaryOutput.length];
                this.secondaryChance = new float[recipe.secondaryOutput.length];
                for (int i = 0; i < this.secondary.length; ++i) {
                    this.secondary[i] = new PositionedStack((Object)recipe.secondaryOutput[i], 90 + i * 18, 40);
                    this.secondaryChance[i] = recipe.secondaryChance[i];
                }
            }
            this.energy = recipe.energy;
        }

        public List<PositionedStack> getOtherStacks() {
            return Arrays.asList(this.secondary != null ? this.secondary : new PositionedStack[]{});
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEICrusherHandler.this.cycleticks / 20, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

