/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.exnihilo.handlers;

import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import exnihilo.utils.ItemInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilo.Hammer")
public class Hammer {
    public static final String name = "ExNihilo Hammer";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, double chance, double luck) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", name));
            return;
        }
        Hammer.addRecipe(input, new IItemStack[]{output}, new double[]{chance}, new double[]{luck});
    }

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack[] output, double[] chance, double[] luck) {
        if (input == null || output == null || chance == null || luck == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", name));
            return;
        }
        if (!InputHelper.isABlock(input)) {
            LogHelper.logError(String.format("Input item for %s recipe must be a block.", name));
            return;
        }
        if (output.length == 0 || output.length != chance.length || output.length != luck.length) {
            LogHelper.logError(String.format("Number of items in arrays are different or null (%d, %d, %d)", output.length, chance.length, luck.length));
            return;
        }
        HashMap<ItemInfo, ArrayList<Smashable>> recipes = new HashMap<ItemInfo, ArrayList<Smashable>>();
        ArrayList<Smashable> list = new ArrayList<Smashable>();
        ItemInfo itemInfo = new ItemInfo(InputHelper.toStack(input));
        recipes.put(itemInfo, list);
        for (int i = 0; i < output.length; ++i) {
            ItemStack out = InputHelper.toStack(output[i]);
            list.add(new Smashable(Block.func_149634_a((Item)itemInfo.getItem()), itemInfo.getMeta(), out.func_77973_b(), out.func_77960_j(), (float)chance[i], (float)luck[i]));
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(recipes));
    }

    @Deprecated
    @ZenMethod
    public static void removeRecipe(IItemStack inputBlock, int inputBlockMeta, IItemStack outputItem, int outputItemMeta) {
        Hammer.removeRecipe((IIngredient)InputHelper.toIItemStack(new ItemStack(InputHelper.toStack(inputBlock).func_77973_b(), 1, inputBlockMeta)), (IIngredient)InputHelper.toIItemStack(new ItemStack(InputHelper.toStack(outputItem).func_77973_b(), 1, outputItemMeta)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input, @Optional IIngredient output) {
        if (input == null) {
            LogHelper.logError(String.format("Required parameters missing for %s recipe.", name));
            return;
        }
        if (output == null) {
            output = IngredientAny.INSTANCE;
        }
        HashMap<ItemInfo, ArrayList<Smashable>> recipes = new HashMap<ItemInfo, ArrayList<Smashable>>();
        for (Map.Entry entry : HammerRegistry.getRewards().entrySet()) {
            if (!input.matches(InputHelper.toIItemStack(((ItemInfo)entry.getKey()).getStack()))) continue;
            ArrayList list = (ArrayList)entry.getValue();
            ArrayList<Smashable> toRemove = new ArrayList<Smashable>();
            for (Smashable recipe : list) {
                ItemStack item = new ItemStack(recipe.item, 1, recipe.meta);
                if (!StackHelper.matches(output, InputHelper.toIItemStack(item))) continue;
                toRemove.add(recipe);
            }
            if (toRemove.isEmpty()) continue;
            recipes.put((ItemInfo)entry.getKey(), toRemove);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipes found for %s and %s. Command ignored!", input.toString(), output.toString()));
        }
    }

    public static ArrayList<Smashable> removeFromList(ArrayList<Smashable> list, Smashable s) {
        ArrayList<Smashable> removed = new ArrayList<Smashable>();
        ItemInfo toRemove = new ItemInfo(s.item, s.meta);
        Iterator<Smashable> it = list.iterator();
        while (it.hasNext()) {
            Smashable itS = it.next();
            ItemInfo item = new ItemInfo(itS.item, itS.meta);
            if (!item.equals((Object)toRemove)) continue;
            removed.add(itS);
            it.remove();
        }
        return removed;
    }

    private static class Remove
    extends BaseMapRemoval<ItemInfo, ArrayList<Smashable>> {
        public Remove(Map<ItemInfo, ArrayList<Smashable>> recipes) {
            super(Hammer.name, HammerRegistry.getRewards(), recipes);
        }

        @Override
        public void apply() {
            for (Map.Entry entry : this.recipes.entrySet()) {
                ArrayList list = (ArrayList)this.map.get(entry.getKey());
                for (Smashable recipe : (ArrayList)entry.getValue()) {
                    Hammer.removeFromList(list, recipe);
                }
                this.successful.put(entry.getKey(), entry.getValue());
            }
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry;
                entry = it.next();
                if (!((ArrayList)entry.getValue()).isEmpty()) continue;
                it.remove();
            }
        }

        @Override
        public void undo() {
            for (Map.Entry entry : this.successful.entrySet()) {
                if (!this.map.containsKey(entry.getKey())) {
                    this.map.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
                    continue;
                }
                ((ArrayList)this.map.get(entry.getKey())).addAll((Collection)entry.getValue());
            }
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, ArrayList<Smashable>> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack()) + " (" + recipe.getValue().size() + " entries)";
        }
    }

    private static class Add
    extends BaseMapAddition<ItemInfo, ArrayList<Smashable>> {
        public Add(Map<ItemInfo, ArrayList<Smashable>> recipes) {
            super(Hammer.name, HammerRegistry.getRewards(), recipes);
        }

        @Override
        public void apply() {
            for (Map.Entry entry : this.recipes.entrySet()) {
                if (!this.map.containsKey(entry.getKey())) {
                    this.map.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
                } else {
                    ArrayList list = (ArrayList)this.map.get(entry.getKey());
                    ArrayList<Smashable> backup = new ArrayList<Smashable>();
                    for (Smashable recipe : (ArrayList)entry.getValue()) {
                        backup.addAll(Hammer.removeFromList(list, recipe));
                    }
                    if (!backup.isEmpty()) {
                        LogHelper.logWarning(String.format("Overwritten %d %s recipe outputs for %s.", backup.size(), Hammer.name, LogHelper.getStackDescription(((ItemInfo)entry.getKey()).getStack())));
                        this.overwritten.put(entry.getKey(), backup);
                    }
                    list.addAll((Collection)entry.getValue());
                }
                this.successful.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void undo() {
            for (Map.Entry entry : this.successful.entrySet()) {
                ArrayList list = (ArrayList)this.map.get(entry.getKey());
                for (Smashable recipe : (ArrayList)entry.getValue()) {
                    Hammer.removeFromList(list, recipe);
                }
            }
            for (Map.Entry entry : this.overwritten.entrySet()) {
                ((ArrayList)this.map.get(entry.getKey())).addAll((Collection)entry.getValue());
            }
            Iterator it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry;
                entry = it.next();
                if (!((ArrayList)entry.getValue()).isEmpty()) continue;
                it.remove();
            }
        }

        @Override
        protected String getRecipeInfo(Map.Entry<ItemInfo, ArrayList<Smashable>> recipe) {
            return LogHelper.getStackDescription(recipe.getKey().getStack()) + " (" + recipe.getValue().size() + " entries)";
        }
    }
}

