/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.bagginses.helpers;

import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelper {
    public static void clearStatefulNBTTags(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "bagOpen")) {
            NBTHelper.removeTag(itemStack, "bagOpen");
        }
    }

    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack.field_77990_d != null) {
            itemStack.field_77990_d.func_82580_o(keyName);
        }
    }

    public static boolean hasUUID(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "UUIDMostSig") && NBTHelper.hasTag(itemStack, "UUIDLeastSig");
    }

    public static void setUUID(ItemStack itemStack) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!NBTHelper.hasTag(itemStack, "UUIDMostSig") && !NBTHelper.hasTag(itemStack, "UUIDLeastSig")) {
            UUID itemUUID = UUID.randomUUID();
            NBTHelper.setLong(itemStack, "UUIDMostSig", itemUUID.getMostSignificantBits());
            NBTHelper.setLong(itemStack, "UUIDLeastSig", itemUUID.getLeastSignificantBits());
        }
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74772_a(keyName, keyValue);
    }

    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public static void setBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74757_a(keyName, keyValue);
    }

    public static void setString(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.field_77990_d.func_74778_a(keyName, keyValue);
    }
}

