/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.proxy;

import com.github.lunatrius.core.util.vector.Vector3d;
import com.github.lunatrius.core.util.vector.Vector3i;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.client.printer.SchematicPrinter;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicGlobal;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.handler.client.ChatEventHandler;
import com.github.lunatrius.schematica.handler.client.InputHandler;
import com.github.lunatrius.schematica.handler.client.OverlayHandler;
import com.github.lunatrius.schematica.handler.client.RenderTickHandler;
import com.github.lunatrius.schematica.handler.client.TickHandler;
import com.github.lunatrius.schematica.handler.client.WorldHandler;
import com.github.lunatrius.schematica.proxy.CommonProxy;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.common.util.ForgeDirection;

public class ClientProxy
extends CommonProxy {
    public static boolean isRenderingGuide = false;
    public static boolean isPendingReset = false;
    public static final Vector3d playerPosition = new Vector3d();
    public static ForgeDirection orientation = ForgeDirection.UNKNOWN;
    public static int rotationRender = 0;
    public static SchematicWorld schematic = null;
    public static final Vector3i pointA = new Vector3i();
    public static final Vector3i pointB = new Vector3i();
    public static final Vector3i pointMin = new Vector3i();
    public static final Vector3i pointMax = new Vector3i();
    public static MovingObjectPosition movingObjectPosition = null;
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    private SchematicWorld schematicWorld = null;

    public static void setPlayerData(EntityPlayer player, float partialTicks) {
        ClientProxy.playerPosition.x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        ClientProxy.playerPosition.y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        ClientProxy.playerPosition.z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        orientation = ClientProxy.getOrientation(player);
        rotationRender = MathHelper.func_76128_c((double)(player.field_70177_z / 90.0f)) & 3;
    }

    private static ForgeDirection getOrientation(EntityPlayer player) {
        if (player.field_70125_A > 45.0f) {
            return ForgeDirection.DOWN;
        }
        if (player.field_70125_A < -45.0f) {
            return ForgeDirection.UP;
        }
        switch (MathHelper.func_76128_c((double)((double)player.field_70177_z / 90.0 + 0.5)) & 3) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static void updatePoints() {
        ClientProxy.pointMin.x = Math.min(ClientProxy.pointA.x, ClientProxy.pointB.x);
        ClientProxy.pointMin.y = Math.min(ClientProxy.pointA.y, ClientProxy.pointB.y);
        ClientProxy.pointMin.z = Math.min(ClientProxy.pointA.z, ClientProxy.pointB.z);
        ClientProxy.pointMax.x = Math.max(ClientProxy.pointA.x, ClientProxy.pointB.x);
        ClientProxy.pointMax.y = Math.max(ClientProxy.pointA.y, ClientProxy.pointB.y);
        ClientProxy.pointMax.z = Math.max(ClientProxy.pointA.z, ClientProxy.pointB.z);
    }

    public static void movePointToPlayer(Vector3i point) {
        point.x = (int)Math.floor(ClientProxy.playerPosition.x);
        point.y = (int)Math.floor(ClientProxy.playerPosition.y - 1.0);
        point.z = (int)Math.floor(ClientProxy.playerPosition.z);
        switch (rotationRender) {
            case 0: {
                --point.x;
                ++point.z;
                break;
            }
            case 1: {
                --point.x;
                --point.z;
                break;
            }
            case 2: {
                ++point.x;
                --point.z;
                break;
            }
            case 3: {
                ++point.x;
                ++point.z;
            }
        }
    }

    public static void moveSchematicToPlayer(SchematicWorld schematic) {
        if (schematic != null) {
            Vector3i position = schematic.position;
            position.x = (int)Math.floor(ClientProxy.playerPosition.x);
            position.y = (int)Math.floor(ClientProxy.playerPosition.y) - 1;
            position.z = (int)Math.floor(ClientProxy.playerPosition.z);
            switch (rotationRender) {
                case 0: {
                    position.x -= schematic.getWidth();
                    ++position.z;
                    break;
                }
                case 1: {
                    position.x -= schematic.getWidth();
                    position.z -= schematic.getLength();
                    break;
                }
                case 2: {
                    ++position.x;
                    position.z -= schematic.getLength();
                    break;
                }
                case 3: {
                    ++position.x;
                    ++position.z;
                }
            }
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Property[] sliders;
        super.preInit(event);
        for (Property property : sliders = new Property[]{ConfigurationHandler.propAlpha, ConfigurationHandler.propBlockDelta, ConfigurationHandler.propPlaceDelay, ConfigurationHandler.propTimeout}) {
            property.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
        for (Property property : InputHandler.KEY_BINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)property);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        FMLCommonHandler.instance().bus().register((Object)InputHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)TickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)RenderTickHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)ConfigurationHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RendererSchematicGlobal.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ChatEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new OverlayHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldHandler());
    }

    @Override
    public File getDataDirectory() {
        File file = ClientProxy.MINECRAFT.field_71412_D;
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            Reference.logger.debug("Could not canonize path!", (Throwable)e);
            return file;
        }
    }

    @Override
    public void resetSettings() {
        super.resetSettings();
        ChatEventHandler.INSTANCE.chatLines = 0;
        SchematicPrinter.INSTANCE.setEnabled(true);
        this.unloadSchematic();
        playerPosition.set(0.0, 0.0, 0.0);
        orientation = ForgeDirection.UNKNOWN;
        rotationRender = 0;
        pointA.set(0, 0, 0);
        pointB.set(0, 0, 0);
        ClientProxy.updatePoints();
    }

    @Override
    public void unloadSchematic() {
        schematic = null;
        RendererSchematicGlobal.INSTANCE.destroyRendererSchematicChunks();
        SchematicPrinter.INSTANCE.setSchematic(null);
    }

    @Override
    public boolean loadSchematic(EntityPlayer player, File directory, String filename) {
        ISchematic schematic = SchematicFormat.readFromFile(directory, filename);
        if (schematic == null) {
            return false;
        }
        SchematicWorld world = new SchematicWorld(schematic);
        Reference.logger.debug("Loaded {} [w:{},h:{},l:{}]", new Object[]{filename, world.getWidth(), world.func_72800_K(), world.getLength()});
        ClientProxy.schematic = world;
        RendererSchematicGlobal.INSTANCE.createRendererSchematicChunks(world);
        SchematicPrinter.INSTANCE.setSchematic(world);
        world.isRendering = true;
        return true;
    }

    @Override
    public boolean isPlayerQuotaExceeded(EntityPlayer player) {
        return false;
    }

    @Override
    public File getPlayerSchematicDirectory(EntityPlayer player, boolean privateDirectory) {
        return ConfigurationHandler.schematicDirectory;
    }
}

