/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL11;

public class GLRenderList {
    private final int listID = GLAllocation.func_74526_a((int)1);
    public boolean isValid = true;
    private long lastUsed = System.currentTimeMillis();
    private boolean isFilled = false;

    public int getID() {
        return this.listID;
    }

    public void startListCompile() {
        if (!this.isValid) {
            throw new UnsupportedOperationException("Can't use a removed list");
        }
        GL11.glNewList((int)this.listID, (int)4864);
    }

    public void stopCompile() {
        if (!this.isValid) {
            throw new UnsupportedOperationException("Can't use a removed list");
        }
        GL11.glEndList();
        this.isFilled = true;
    }

    public void render() {
        if (!this.isValid) {
            throw new UnsupportedOperationException("Can't use a removed list");
        }
        GL11.glCallList((int)this.listID);
        this.lastUsed = System.currentTimeMillis();
    }

    public boolean check() {
        if (!this.isValid) {
            return true;
        }
        if (this.lastUsed + 60000L < System.currentTimeMillis()) {
            this.isValid = false;
            return false;
        }
        return true;
    }

    public boolean isInvalid() {
        return !this.isValid;
    }

    public boolean isFilled() {
        return this.isFilled;
    }
}

