/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.debug;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.debug.LogWindow;
import net.minecraft.entity.player.EntityPlayer;

public class SendNewLogWindow
extends ModernPacket {
    private int windowID;
    private String title;

    public SendNewLogWindow(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.windowID = data.readInt();
        this.title = data.readUTF();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogWindow.getWindow(this.windowID).setTitle(this.title);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeInt(this.windowID);
        data.writeUTF(this.title);
    }

    @Override
    public ModernPacket template() {
        return new SendNewLogWindow(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public int getWindowID() {
        return this.windowID;
    }

    public SendNewLogWindow setWindowID(int windowID) {
        this.windowID = windowID;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public SendNewLogWindow setTitle(String title) {
        this.title = title;
        return this;
    }
}

