/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import net.minecraft.entity.player.EntityPlayer;

public abstract class ModernPacket {
    private boolean isChunkDataPacket;
    private boolean compressable;
    private final int id;
    private byte[] data = null;
    private int debugId = 0;
    protected int leftRetries = 5;

    public ModernPacket(int id) {
        this.id = id;
    }

    public abstract void readData(LPDataInputStream var1) throws IOException;

    public abstract void processPacket(EntityPlayer var1);

    public abstract void writeData(LPDataOutputStream var1) throws IOException;

    public abstract ModernPacket template();

    public boolean retry() {
        return this.leftRetries-- > 0;
    }

    public boolean isChunkDataPacket() {
        return this.isChunkDataPacket;
    }

    public ModernPacket setChunkDataPacket(boolean isChunkDataPacket) {
        this.isChunkDataPacket = isChunkDataPacket;
        return this;
    }

    public boolean isCompressable() {
        return this.compressable;
    }

    public ModernPacket setCompressable(boolean compressable) {
        this.compressable = compressable;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getDebugId() {
        return this.debugId;
    }

    public ModernPacket setDebugId(int debugId) {
        this.debugId = debugId;
        return this;
    }
}

