/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.utils;

import com.whammich.sstow.events.Achievements;
import com.whammich.sstow.utils.Config;
import com.whammich.sstow.utils.Register;
import com.whammich.sstow.utils.TierHandler;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public final class Utils {
    public static ItemStack getShardFromInv(EntityPlayer player, String entity) {
        ItemStack lastResort = null;
        for (int i = 0; i <= 8; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != Register.SOUL_SHARD || Utils.hasMaxedKills(stack)) continue;
            if (!Utils.isShardBound(stack) && lastResort == null) {
                lastResort = stack;
                continue;
            }
            if (!Utils.getShardBoundEnt(stack).equals(entity)) continue;
            return stack;
        }
        if (lastResort != null && lastResort.field_77994_a > 1) {
            boolean emptySpot = false;
            ItemStack newShard = new ItemStack(Register.SOUL_SHARD, 1);
            for (int counter = 0; !emptySpot && counter < 36; ++counter) {
                ItemStack inventoryStack = player.field_71071_by.func_70301_a(counter);
                if (inventoryStack != null) continue;
                --lastResort.field_77994_a;
                player.field_71071_by.func_70441_a(newShard);
                emptySpot = true;
                return player.field_71071_by.func_70301_a(counter);
            }
            if (!emptySpot) {
                --lastResort.field_77994_a;
                if (!Utils.isShardBound(newShard)) {
                    Utils.setShardBoundEnt(newShard, entity);
                    Utils.writeEntityHeldItem(newShard, (EntityLiving)EntityList.func_75620_a((String)entity, (World)player.field_70170_p));
                }
                int soulStealer = EnchantmentHelper.func_77506_a((int)Register.SOUL_STEALER.field_77352_x, (ItemStack)player.func_70694_bm());
                Utils.increaseShardKillCount(newShard, (short)(1 + (soulStealer *= Config.ENCHANT_KILL_BONUS)));
                Utils.checkForAchievements(player, newShard);
                player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, newShard));
                return null;
            }
        }
        return lastResort;
    }

    public static void checkForAchievements(EntityPlayer player, ItemStack shard) {
        byte tier = Utils.getShardTier(shard);
        switch (tier) {
            case 0: {
                break;
            }
            case 1: {
                player.func_71064_a((StatBase)Achievements.shardt1, 1);
                break;
            }
            case 2: {
                player.func_71064_a((StatBase)Achievements.shardt2, 1);
                break;
            }
            case 3: {
                player.func_71064_a((StatBase)Achievements.shardt3, 1);
                break;
            }
            case 4: {
                player.func_71064_a((StatBase)Achievements.shardt4, 1);
                break;
            }
            case 5: {
                player.func_71064_a((StatBase)Achievements.shardt5, 1);
                break;
            }
        }
    }

    public static short getShardKillCount(ItemStack shard) {
        if (!shard.func_77942_o()) {
            return 0;
        }
        return (short)MathHelper.func_76125_a((int)shard.field_77990_d.func_74765_d("KillCount"), (int)0, (int)TierHandler.getMaxKills(5));
    }

    public static void increaseShardKillCount(ItemStack shard, short amount) {
        if (!shard.func_77942_o() || Utils.hasMaxedKills(shard)) {
            return;
        }
        Utils.setShardKillCount(shard, Utils.getClampedKillCount(Utils.getShardKillCount(shard) + amount));
        Utils.checkAndFixShard(shard);
    }

    public static void checkAndFixShard(ItemStack shard) {
        if (!TierHandler.isShardValid(shard)) {
            Utils.setShardTier(shard, TierHandler.getCorrectTier(shard));
        }
    }

    public static void setShardKillCount(ItemStack shard, short value) {
        if (!shard.func_77942_o()) {
            shard.func_77982_d(new NBTTagCompound());
        }
        shard.field_77990_d.func_74777_a("KillCount", value);
    }

    public static byte getShardTier(ItemStack shard) {
        if (!shard.func_77942_o()) {
            return 0;
        }
        return (byte)MathHelper.func_76125_a((int)shard.field_77990_d.func_74771_c("Tier"), (int)0, (int)5);
    }

    public static void setShardTier(ItemStack shard, byte tier) {
        if (!shard.func_77942_o()) {
            shard.func_77982_d(new NBTTagCompound());
        }
        shard.field_77990_d.func_74774_a("Tier", (byte)MathHelper.func_76125_a((int)tier, (int)0, (int)5));
    }

    public static String getShardBoundEnt(ItemStack shard) {
        if (!shard.func_77942_o()) {
            return "";
        }
        return shard.field_77990_d.func_74779_i("Entity");
    }

    public static void setShardBoundEnt(ItemStack shard, String value) {
        if (!shard.func_77942_o()) {
            shard.func_77982_d(new NBTTagCompound());
            shard.field_77990_d.func_74780_a("antiStack", new Random().nextDouble());
        }
        shard.field_77990_d.func_74778_a("Entity", value);
    }

    public static boolean isShardBound(ItemStack shard) {
        return !Utils.getShardBoundEnt(shard).isEmpty();
    }

    public static boolean hasMaxedKills(ItemStack shard) {
        return Utils.isShardBound(shard) && Utils.getShardKillCount(shard) >= TierHandler.getMaxKills(5);
    }

    public static String getEntityNameTransltated(String unlocalName) {
        if (unlocalName.equals("Wither Skeleton")) {
            return unlocalName;
        }
        String result = StatCollector.func_74838_a((String)("entity." + unlocalName + ".name"));
        if (result == null) {
            return unlocalName;
        }
        return result;
    }

    private static short getClampedKillCount(int amount) {
        int value = MathHelper.func_76125_a((int)amount, (int)0, (int)TierHandler.getMaxKills(5));
        if (value > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        return (short)value;
    }

    public static void writeEntityHeldItem(ItemStack shard, EntityLiving ent) {
        if (ent instanceof EntityZombie || ent instanceof EntityEnderman) {
            return;
        }
        ItemStack held = ent.func_70694_bm();
        if (held != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            held.func_77955_b(nbt);
            if (nbt.func_74764_b("ench")) {
                nbt.func_82580_o("ench");
            }
            shard.field_77990_d.func_74782_a("HeldItem", (NBTBase)nbt);
        }
    }

    public static ItemStack getEntityHeldItem(ItemStack shard) {
        if (!shard.func_77942_o()) {
            return null;
        }
        if (shard.field_77990_d.func_74764_b("HeldItem")) {
            return ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)shard.field_77990_d.func_74781_a("HeldItem")));
        }
        return null;
    }

    public static void writeEntityArmor(ItemStack shard, EntityLiving ent) {
        for (int i = 1; i <= 4; ++i) {
            ItemStack armor = ent.func_71124_b(i);
            if (armor != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                armor.func_77955_b(nbt);
                if (nbt.func_74764_b("ench")) {
                    nbt.func_82580_o("ench");
                }
                if (shard.field_77990_d.func_74764_b("armor" + i)) {
                    NBTTagCompound oldnbt;
                    ItemStack oldArmor;
                    if (shard.field_77990_d.func_74781_a("armor" + i) == null || (oldArmor = ItemStack.func_77949_a((NBTTagCompound)(oldnbt = (NBTTagCompound)shard.field_77990_d.func_74781_a("armor" + i)))).func_77973_b() == armor.func_77973_b()) continue;
                    shard.field_77990_d.func_82580_o("armor" + i);
                    continue;
                }
                shard.field_77990_d.func_74782_a("armor" + i, (NBTBase)nbt);
                continue;
            }
            shard.field_77990_d.func_82580_o("armor" + i);
        }
    }

    public static ItemStack getEntityArmor(ItemStack shard, int armorSlot) {
        if (shard.field_77990_d.func_74764_b("armor" + armorSlot) && shard.field_77990_d.func_74781_a("armor" + armorSlot) != null) {
            NBTTagCompound oldnbt = (NBTTagCompound)shard.field_77990_d.func_74781_a("armor" + armorSlot);
            ItemStack oldArmor = ItemStack.func_77949_a((NBTTagCompound)oldnbt);
            return oldArmor;
        }
        return null;
    }
}

