/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.utils;

import com.whammich.sstow.utils.ModLogger;
import com.whammich.sstow.utils.Utils;
import net.minecraft.item.ItemStack;

public final class TierHandler {
    public static short[] MIN_KILLS = new short[]{0, 64, 128, 256, 512, 1024};
    private static short[] MAX_KILLS = new short[]{63, 127, 255, 511, 1023, 1024};
    private static boolean[] NEEDS_PLAYER = new boolean[]{true, true, false, false, false};
    private static boolean[] CHECKS_LIGHT = new boolean[]{true, true, true, true, false};
    private static boolean[] CHECKS_WORLD = new boolean[]{true, true, true, false, false};
    private static boolean[] CHECKS_REDSTONE = new boolean[]{false, false, false, false, true};
    private static byte[] NUM_SPAWNS = new byte[]{2, 4, 4, 4, 6};
    private static byte[] SPAWN_DELAY = new byte[]{20, 10, 5, 5, 2};

    public static void setPlayerChecks(int tier, boolean value) {
        TierHandler.NEEDS_PLAYER[tier] = value;
    }

    public static void setLightChecks(int tier, boolean value) {
        TierHandler.CHECKS_LIGHT[tier] = value;
    }

    public static void setWorldChecks(int tier, boolean value) {
        TierHandler.CHECKS_WORLD[tier] = value;
    }

    public static void setRedstoneChecks(int tier, boolean value) {
        TierHandler.CHECKS_REDSTONE[tier] = value;
    }

    public static void setNumSpawns(int tier, byte value) {
        TierHandler.NUM_SPAWNS[tier] = value;
    }

    public static void setSpawnDelay(int tier, byte value) {
        TierHandler.SPAWN_DELAY[tier] = value;
    }

    public static boolean getChecksPlayer(int tier) {
        return NEEDS_PLAYER[tier];
    }

    public static boolean getChecksLight(int tier) {
        return CHECKS_LIGHT[tier];
    }

    public static boolean getChecksWorld(int tier) {
        return CHECKS_WORLD[tier];
    }

    public static boolean getChecksRedstone(int tier) {
        return CHECKS_REDSTONE[tier];
    }

    public static byte getNumSpawns(int tier) {
        return NUM_SPAWNS[tier];
    }

    public static byte getCooldown(int tier) {
        return SPAWN_DELAY[tier];
    }

    public static short getMinKills(int tier) {
        return MIN_KILLS[tier];
    }

    public static short getMaxKills(int tier) {
        return MAX_KILLS[tier];
    }

    public static void setTierReqKills(short[] minKills) {
        int i;
        boolean error = false;
        short[] tempMin = new short[6];
        short[] tempMax = new short[6];
        tempMin[0] = 0;
        tempMax[0] = (short)(minKills[0] - 1);
        for (i = 0; i < 5; ++i) {
            tempMin[i + 1] = minKills[i];
            tempMax[i + 1] = i < 4 ? (short)(minKills[i + 1] - 1) : minKills[i];
        }
        block1: for (i = 1; i < 6; ++i) {
            for (int j = 0; j < i; ++j) {
                if (tempMin[i] > tempMin[j]) continue;
                error = true;
                continue block1;
            }
        }
        if (error) {
            ModLogger.logFatal("Custom tier kill settings are incorrect, resetting defaults.");
        } else {
            MIN_KILLS = tempMin;
            MAX_KILLS = tempMax;
            ModLogger.logInfo("Loaded custom tier kill settings!");
        }
        ModLogger.logInfo("Min kills: " + TierHandler.arrayToString(MIN_KILLS));
        ModLogger.logInfo("Max kills: " + TierHandler.arrayToString(MAX_KILLS));
    }

    public static boolean isShardValid(ItemStack shard) {
        byte tier;
        short kills = Utils.getShardKillCount(shard);
        return kills >= MIN_KILLS[tier = Utils.getShardTier(shard)] && kills <= MAX_KILLS[tier];
    }

    public static byte getCorrectTier(ItemStack shard) {
        short kills = Utils.getShardKillCount(shard);
        for (byte i = 0; i <= 5; i = (byte)((byte)(i + 1))) {
            if (kills < MIN_KILLS[i] || kills > MAX_KILLS[i]) continue;
            return i;
        }
        ModLogger.logFatal("Soul shard has an incorrect kill counter of: " + kills);
        return 0;
    }

    private static String arrayToString(short[] array) {
        String message = "";
        for (int i = 0; i < array.length; ++i) {
            message = message + array[i];
            if (i >= array.length - 1) continue;
            message = message + ",";
        }
        return message;
    }
}

