/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.guihandler;

import com.whammich.sstow.utils.Config;
import com.whammich.sstow.utils.Register;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class SFRecipeHandler {
    private static final SFRecipeHandler SMELTING_BASE = new SFRecipeHandler();
    private Map<ItemStack, ItemStack> smeltingList = new HashMap<ItemStack, ItemStack>();
    private Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static SFRecipeHandler smelting() {
        return SMELTING_BASE;
    }

    private ItemStack NuggetIngot() {
        if (Config.NUGGETS == 9) {
            return new ItemStack(Register.MATERIALS, 1, 2);
        }
        return new ItemStack(Register.MATERIALS, Config.NUGGETS, 1);
    }

    private ItemStack IngotBlock() {
        if (Config.INGOTS == 9) {
            return new ItemStack(Register.SOULIUM_BLOCK, 1);
        }
        return new ItemStack(Register.MATERIALS, Config.INGOTS, 2);
    }

    private SFRecipeHandler() {
        if (!Config.EASYMODE) {
            this.addRecipe(new ItemStack(Items.field_151045_i), new ItemStack(Register.SOUL_SHARD, Config.SHARDS), 1.0f);
        }
        this.addRecipe(new ItemStack(Items.field_151042_j), this.NuggetIngot(), 0.8f);
        this.addRecipe(new ItemStack(Blocks.field_150339_S), this.IngotBlock(), 1.0f);
    }

    public void addRecipe(ItemStack input, ItemStack output, float experience) {
        this.smeltingList.put(input, output);
        this.experienceList.put(output, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack itemstack) {
        Map.Entry<ItemStack, ItemStack> entry;
        Iterator<Map.Entry<ItemStack, ItemStack>> iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.canBeSmelted(itemstack, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    private boolean canBeSmelted(ItemStack itemstack, ItemStack itemstack2) {
        return itemstack2.func_77973_b() == itemstack.func_77973_b() && (itemstack2.func_77960_j() == Short.MAX_VALUE || itemstack2.func_77960_j() == itemstack.func_77960_j());
    }

    public float giveExperience(ItemStack itemstack) {
        Map.Entry<ItemStack, Float> entry;
        Iterator<Map.Entry<ItemStack, Float>> iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.canBeSmelted(itemstack, (entry = iterator.next()).getKey()));
        if (itemstack.func_77973_b().getSmeltingExperience(itemstack) != -1.0f) {
            return itemstack.func_77973_b().getSmeltingExperience(itemstack);
        }
        return entry.getValue().floatValue();
    }
}

